/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientBeanDefinitionHandler;
import grpcstarter.client.GrpcClientProperties;
import grpcstarter.client.GrpcClientUtil;
import grpcstarter.client.GrpcStubBeanRegistrar;
import grpcstarter.client.ScanInfo;
import grpcstarter.client.Util;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

class GrpcStubBeanDefinitionRegistry
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    static final ScanInfo scanInfo = new ScanInfo();
    private Environment environment;

    GrpcStubBeanDefinitionRegistry() {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        boolean enabled = (Boolean)this.environment.getProperty("grpc.client.enabled", Boolean.class, (Object)true);
        if (!enabled) {
            return;
        }
        GrpcClientProperties properties = Util.getProperties(this.environment);
        this.registerChannels(registry, properties);
        this.registerStubs(new GrpcStubBeanRegistrar(registry), properties);
    }

    private void registerChannels(BeanDefinitionRegistry registry, GrpcClientProperties properties) {
        DefaultListableBeanFactory bf = (DefaultListableBeanFactory)registry;
        GrpcClientUtil.registerGrpcChannelBeans(bf, this.environment, properties);
    }

    private void registerStubs(GrpcStubBeanRegistrar registrar, GrpcClientProperties properties) {
        if ((GrpcStubBeanDefinitionRegistry.scanInfo.beanDefinitionHandler == null || GrpcStubBeanDefinitionRegistry.scanInfo.beanDefinitionHandler == GrpcClientBeanDefinitionHandler.Default.class) && properties.getBeanDefinitionHandler() != null) {
            GrpcStubBeanDefinitionRegistry.scanInfo.beanDefinitionHandler = properties.getBeanDefinitionHandler();
        }
        GrpcStubBeanDefinitionRegistry.scanInfo.basePackages.addAll(properties.getBasePackages());
        GrpcStubBeanDefinitionRegistry.scanInfo.clients.addAll(properties.getClients());
        if (!ObjectUtils.isEmpty(GrpcStubBeanDefinitionRegistry.scanInfo.basePackages)) {
            registrar.register((String[])GrpcStubBeanDefinitionRegistry.scanInfo.basePackages.toArray(String[]::new));
        }
        if (!ObjectUtils.isEmpty(GrpcStubBeanDefinitionRegistry.scanInfo.clients)) {
            registrar.register((Class[])GrpcStubBeanDefinitionRegistry.scanInfo.clients.toArray(Class[]::new));
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

