/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientUtil;
import grpcstarter.client.Util;
import io.grpc.stub.AbstractStub;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;

class GrpcStubBeanRegistrar {
    private static final Logger log = LoggerFactory.getLogger(GrpcStubBeanRegistrar.class);
    private final ClassPathScanningCandidateComponentProvider scanner = GrpcStubBeanRegistrar.getScanner();
    private final BeanDefinitionRegistry registry;
    private static final HashMap<BeanDefinitionRegistry, Map<Class<?>, List<BeanDefinition>>> beanDefinitionMap = new HashMap();

    public GrpcStubBeanRegistrar(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public void register(String ... basePackages) {
        LinkedHashSet beanDefinitions = new LinkedHashSet();
        for (String pkg : basePackages) {
            beanDefinitions.addAll(this.scanner.findCandidateComponents(pkg));
        }
        for (BeanDefinition bd : beanDefinitions) {
            Class<?> clz = Util.getBeanDefinitionClass(bd);
            if (clz == null) continue;
            this.registerGrpcStubBean(clz);
        }
    }

    public void register(Class<?> ... clients) {
        for (Class<?> client : clients) {
            this.registerGrpcStubBean(client);
        }
    }

    private void registerGrpcStubBean(Class<?> clz) {
        BeanDefinitionRegistry beanDefinitionRegistry = this.registry;
        if (!(beanDefinitionRegistry instanceof DefaultListableBeanFactory)) {
            throw new IllegalArgumentException("registry must be instance of DefaultListableBeanFactory");
        }
        DefaultListableBeanFactory dlb = (DefaultListableBeanFactory)beanDefinitionRegistry;
        GrpcStubBeanRegistrar.addBeanDefinitionCache(dlb);
        if (GrpcStubBeanRegistrar.hasManualRegistered((BeanDefinitionRegistry)dlb, clz)) {
            if (log.isDebugEnabled()) {
                log.debug("gRPC client bean '{}' is already registered, skip auto registration", (Object)clz.getName());
            }
            return;
        }
        GrpcClientUtil.registerGrpcClientBean(dlb, clz);
    }

    private static boolean hasManualRegistered(BeanDefinitionRegistry registry, Class<?> clz) {
        return !beanDefinitionMap.getOrDefault(registry, Map.of()).getOrDefault(clz, List.of()).isEmpty();
    }

    private static void addBeanDefinitionCache(DefaultListableBeanFactory bf) {
        if (beanDefinitionMap.containsKey(bf)) {
            return;
        }
        for (String beanDefinitionName : bf.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = bf.getBeanDefinition(beanDefinitionName);
            Class<?> clz = Util.getBeanDefinitionClass(beanDefinition);
            if (clz == null) continue;
            beanDefinitionMap.computeIfAbsent((BeanDefinitionRegistry)bf, k -> new HashMap()).computeIfAbsent(clz, k -> new ArrayList()).add(beanDefinition);
        }
    }

    private static ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider s = new ClassPathScanningCandidateComponentProvider(false);
        s.addIncludeFilter((metadataReader, metadataReaderFactory) -> GrpcStubBeanRegistrar.isGrpcStub(metadataReader));
        return s;
    }

    private static boolean isGrpcStub(MetadataReader mr) {
        boolean isStub;
        ClassMetadata cm = mr.getClassMetadata();
        boolean bl = isStub = cm.hasSuperClass() && cm.hasEnclosingClass() && cm.getClassName().endsWith("Stub");
        if (!isStub) {
            return false;
        }
        try {
            Class<?> clz = Class.forName(cm.getClassName());
            if (AbstractStub.class.isAssignableFrom(clz)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static void clearBeanDefinitionCache(BeanDefinitionRegistry registry) {
        beanDefinitionMap.remove(registry);
    }
}

