/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientProperties;
import io.grpc.ManagedChannel;
import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    public static final String SERVICE_NAME = "SERVICE_NAME";
    private static final AntPathMatcher matcher = new AntPathMatcher(".");

    public static Optional<GrpcClientProperties.Channel> findMatchedConfig(Class<?> stubClass, GrpcClientProperties properties) {
        Optional<GrpcClientProperties.Channel> foundClassConfig = properties.getChannels().stream().filter(ch -> Util.matchAnyClassesConfig(stubClass, ch)).findFirst();
        if (foundClassConfig.isPresent()) {
            return foundClassConfig;
        }
        Optional<GrpcClientProperties.Channel> foundStubConfig = properties.getChannels().stream().filter(ch -> Util.matchAnyStubsConfig(stubClass, ch)).findFirst();
        if (foundStubConfig.isPresent()) {
            return foundStubConfig;
        }
        return properties.getChannels().stream().filter(it -> Util.matchAnyServicesConfig(stubClass, it)).findFirst();
    }

    private static boolean matchAnyServicesConfig(Class<?> stubClass, GrpcClientProperties.Channel channelConfig) {
        String service = Util.serviceName(stubClass);
        return channelConfig.getServices().stream().anyMatch(svcPattern -> Util.matchPattern(svcPattern, service));
    }

    private static boolean matchAnyStubsConfig(Class<?> stubClass, GrpcClientProperties.Channel channelConfig) {
        return channelConfig.getStubs().stream().anyMatch(stub -> Util.matchStubConfig(stub, stubClass));
    }

    private static boolean matchAnyClassesConfig(Class<?> stubClass, GrpcClientProperties.Channel channelConfig) {
        return channelConfig.getClasses().stream().anyMatch(ch -> ch == stubClass);
    }

    public static boolean matchStubConfig(String stub, Class<?> stubClass) {
        return Util.matchPattern(stub, stubClass.getCanonicalName()) || Util.matchPattern(stub, stubClass.getName());
    }

    public static boolean matchPattern(String pattern, String service) {
        return matcher.match(pattern, service);
    }

    public static String serviceName(Class<?> stubClass) {
        Field serviceNameField = ReflectionUtils.findField(stubClass.getEnclosingClass(), (String)SERVICE_NAME);
        Assert.notNull((Object)serviceNameField, (String)"SERVICE_NAME field not found");
        return (String)ReflectionUtils.getField((Field)serviceNameField, null);
    }

    public static GrpcClientProperties getProperties(Environment environment) {
        GrpcClientProperties properties = (GrpcClientProperties)Binder.get((Environment)environment).bind("grpc.client", GrpcClientProperties.class).orElseGet(GrpcClientProperties::new);
        properties.afterPropertiesSet();
        return properties;
    }

    public static void shutdownChannel(ManagedChannel channel, Duration timeout) {
        if (channel == null || channel.isTerminated()) {
            return;
        }
        long ms = timeout.toMillis();
        try {
            channel.shutdown();
            if (!channel.awaitTermination(ms, TimeUnit.MILLISECONDS)) {
                log.warn("Graceful shutdown timed out: {}ms, channel: {}", (Object)ms, (Object)channel);
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted gracefully shutting down channel: {}", (Object)channel);
            Thread.currentThread().interrupt();
        }
        if (!channel.isTerminated()) {
            try {
                channel.shutdownNow();
                if (!channel.awaitTermination(15L, TimeUnit.SECONDS)) {
                    log.warn("Forcefully shutdown timed out: 15s, channel: {}. ", (Object)channel);
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted forcefully shutting down channel: {}. ", (Object)channel);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Nullable
    public static Class<?> getBeanDefinitionClass(BeanDefinition beanDefinition) {
        AnnotatedBeanDefinition abd;
        MethodMetadata metadata;
        if (beanDefinition instanceof AnnotatedBeanDefinition && (metadata = (abd = (AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) != null) {
            return Util.forName(metadata.getReturnTypeName());
        }
        ResolvableType rt = beanDefinition.getResolvableType();
        if (ResolvableType.NONE.equalsType(rt)) {
            String beanClassName = beanDefinition.getBeanClassName();
            if (beanClassName == null) {
                return null;
            }
            return Util.forName(beanClassName);
        }
        return rt.resolve();
    }

    @Nullable
    public static Class<?> forName(String beanClassName) {
        try {
            return Class.forName(beanClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public static GrpcClientProperties.Channel findChannelByName(String name, GrpcClientProperties properties) {
        for (GrpcClientProperties.Channel ch : properties.getChannels()) {
            if (!Objects.equals(ch.getName(), name)) continue;
            return ch;
        }
        GrpcClientProperties.Channel defaultChannel = properties.defaultChannel();
        if (Objects.equals(defaultChannel.getName(), name)) {
            return defaultChannel;
        }
        return null;
    }

    @Generated
    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

