/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client.exception;

import grpcstarter.client.exception.MissingChannelConfigurationException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class GrpcClientFailureAnalyzer
extends AbstractFailureAnalyzer<MissingChannelConfigurationException> {
    protected FailureAnalysis analyze(Throwable rootFailure, MissingChannelConfigurationException cause) {
        return new FailureAnalysis(cause.getMessage(), "Please configure the gRPC channel authority for the stub: " + cause.getStubClass().getName() + "\n\nYou can configure the channel authority in application.yml:\n\nConfigure channel authority globally:\ngrpc:\n  client:\n    authority: localhost:9090\n\nOr configure channel authority for the specific stub:\ngrpc:\n  client:\n    channels:\n      - authority: localhost:9090\n        classes: " + cause.getStubClass().getCanonicalName(), (Throwable)cause);
    }
}

