/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import grpcstarter.extensions.transcoding.HeaderConverter;
import io.grpc.Metadata;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ReflectionUtils;

public class DefaultHeaderConverter
implements HeaderConverter {
    private final Set<String> removeHeaders = this.getRemoveHeaders();

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public DefaultHeaderConverter() {
    }

    @Override
    public Metadata toMetadata(HttpHeaders headers) {
        Metadata metadata = new Metadata();
        headers.forEach((k, values) -> {
            if (!this.removeHeaders.contains(k.toLowerCase())) {
                values.forEach(v -> metadata.put(Metadata.Key.of((String)k, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), v));
            }
        });
        return metadata;
    }

    @Override
    public HttpHeaders toHttpHeaders(Metadata headers) {
        HttpHeaders result = new HttpHeaders();
        for (String key : headers.keys()) {
            if (this.removeHeaders.contains(key.toLowerCase()) || key.startsWith("grpc-") || key.endsWith("-bin")) continue;
            Optional.ofNullable(headers.getAll(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))).ifPresent(values -> values.forEach(value -> result.add(key, value)));
        }
        return result;
    }

    private Set<String> getRemoveHeaders() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(DefaultHeaderConverter.getHttpHeaders());
        result.removeIf("Authorization"::equalsIgnoreCase);
        return result;
    }

    private static Set<String> getHttpHeaders() {
        return Arrays.stream(HttpHeaders.class.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && f.getType() == String.class).map(f -> ReflectionUtils.getField((Field)f, null)).filter(Objects::nonNull).map(Object::toString).map(String::toLowerCase).collect(Collectors.toSet());
    }
}

