/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import grpcstarter.extensions.transcoding.HeaderConverter;
import grpcstarter.extensions.transcoding.ReactiveTranscodingExceptionResolver;
import grpcstarter.extensions.transcoding.TranscodingRuntimeException;
import grpcstarter.extensions.transcoding.TranscodingUtil;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.MonoSink;

public class DefaultReactiveTranscodingExceptionResolver
implements ReactiveTranscodingExceptionResolver {
    private final HeaderConverter headerConverter;

    public DefaultReactiveTranscodingExceptionResolver(HeaderConverter headerConverter) {
        this.headerConverter = headerConverter;
    }

    @Override
    public void resolve(MonoSink<ServerResponse> sink, StatusRuntimeException exception) {
        Metadata trailers = exception.getTrailers();
        TranscodingRuntimeException e = new TranscodingRuntimeException((HttpStatusCode)TranscodingUtil.toHttpStatus(exception.getStatus()), exception.getMessage(), trailers != null ? this.headerConverter.toHttpHeaders(trailers) : null);
        sink.error((Throwable)((Object)e));
    }
}

