/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import grpcstarter.extensions.transcoding.GrpcTranscodingProperties;
import grpcstarter.extensions.transcoding.HeaderConverter;
import grpcstarter.extensions.transcoding.JsonUtil;
import grpcstarter.extensions.transcoding.ServletTranscoder;
import grpcstarter.extensions.transcoding.Transcoder;
import grpcstarter.extensions.transcoding.TranscodingExceptionResolver;
import grpcstarter.extensions.transcoding.TranscodingRuntimeException;
import grpcstarter.extensions.transcoding.TranscodingUtil;
import grpcstarter.extensions.transcoding.Util;
import grpcstarter.server.GrpcServerProperties;
import grpcstarter.server.GrpcServerStartedEvent;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class DefaultServletTranscoder
implements ServletTranscoder,
DisposableBean,
ApplicationListener<GrpcServerStartedEvent> {
    private static final String MATCHING_ROUTE = String.valueOf(DefaultServletTranscoder.class) + ".matchingRoute";
    private final Map<String, Util.Route<ServerRequest>> autoMappingRoutes = new HashMap<String, Util.Route<ServerRequest>>();
    private final List<Util.Route<ServerRequest>> customRoutes = new ArrayList<Util.Route<ServerRequest>>();
    private final HeaderConverter headerConverter;
    private final GrpcTranscodingProperties grpcTranscodingProperties;
    private final GrpcServerProperties grpcServerProperties;
    private final TranscodingExceptionResolver transcodingExceptionResolver;
    private Channel channel;

    public DefaultServletTranscoder(List<BindableService> services, HeaderConverter headerConverter, GrpcTranscodingProperties grpcTranscodingProperties, GrpcServerProperties grpcServerProperties, TranscodingExceptionResolver transcodingExceptionResolver) {
        Util.fillRoutes(services, this.autoMappingRoutes, this.customRoutes, grpcTranscodingProperties);
        this.headerConverter = headerConverter;
        this.grpcTranscodingProperties = grpcTranscodingProperties;
        this.grpcServerProperties = grpcServerProperties;
        this.transcodingExceptionResolver = transcodingExceptionResolver;
    }

    public void onApplicationEvent(GrpcServerStartedEvent event) {
        this.channel = Util.getTranscodingChannel(event.getSource().getPort(), this.grpcTranscodingProperties, this.grpcServerProperties);
    }

    @Nonnull
    public Optional<HandlerFunction<ServerResponse>> route(@Nonnull ServerRequest request) {
        Util.Route<ServerRequest> route;
        if (Objects.equals(request.method(), HttpMethod.POST) && (route = this.autoMappingRoutes.get(Util.trim(request.path(), '/'))) != null) {
            request.attributes().put(MATCHING_ROUTE, route);
            return Optional.of(this);
        }
        for (Util.Route<ServerRequest> route2 : this.customRoutes) {
            if (!route2.predicate().test(request) && !route2.additionalPredicates().stream().anyMatch(p -> p.test(request))) continue;
            request.attributes().put(MATCHING_ROUTE, route2);
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Nonnull
    public ServerResponse handle(@Nonnull ServerRequest request) {
        Util.Route route = (Util.Route)request.attributes().get(MATCHING_ROUTE);
        MethodDescriptor.MethodType methodType = route.invokeMethod().getType();
        if (methodType == MethodDescriptor.MethodType.UNARY) {
            return this.processUnaryCall(request, route);
        }
        if (methodType == MethodDescriptor.MethodType.SERVER_STREAMING) {
            return this.processServerStreamingCall(request, route);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Unsupported rpc method type: " + String.valueOf(methodType));
    }

    private static ClientCall<Object, Object> getCall(Channel channel, Util.Route<ServerRequest> route) {
        return channel.newCall(route.invokeMethod(), CallOptions.DEFAULT);
    }

    private static Transcoder getTranscoder(ServerRequest request) {
        try {
            return Transcoder.create(new Transcoder.Variable(StreamUtils.copyToByteArray((InputStream)request.servletRequest().getInputStream()), request.servletRequest().getParameterMap(), (Map)request.servletRequest().getAttribute(Util.URI_TEMPLATE_VARIABLES_ATTRIBUTE)));
        }
        catch (IOException e) {
            throw new IllegalStateException("getInputStream failed", e);
        }
    }

    private ServerResponse processUnaryCall(ServerRequest request, Util.Route<ServerRequest> route) {
        Message responseMessage;
        AtomicReference headers = new AtomicReference();
        AtomicReference trailers = new AtomicReference();
        Transcoder transcoder = DefaultServletTranscoder.getTranscoder(request);
        Message req = DefaultServletTranscoder.getMessage(route, transcoder);
        Channel chan = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{MetadataUtils.newCaptureMetadataInterceptor(headers, trailers), MetadataUtils.newAttachHeadersInterceptor((Metadata)this.headerConverter.toMetadata(request.headers().asHttpHeaders()))});
        ClientCall<Object, Object> call = DefaultServletTranscoder.getCall(chan, route);
        try {
            responseMessage = (Message)ClientCalls.blockingUnaryCall(call, (Object)req);
        }
        catch (StatusRuntimeException sre) {
            return this.transcodingExceptionResolver.resolve(sre);
        }
        ServerResponse.BodyBuilder builder = (ServerResponse.BodyBuilder)ServerResponse.ok().headers(h -> {
            Metadata m = (Metadata)headers.get();
            if (m != null) {
                h.addAll((MultiValueMap)this.headerConverter.toHttpHeaders(m));
            }
        });
        Object body = transcoder.out(responseMessage, route.httpRule());
        if (JsonUtil.canParseJson(body)) {
            builder.contentType(MediaType.APPLICATION_JSON);
        }
        return builder.body((Object)JsonUtil.toJson(body));
    }

    private ServerResponse processServerStreamingCall(ServerRequest request, final Util.Route<ServerRequest> route) {
        final Transcoder transcoder = DefaultServletTranscoder.getTranscoder(request);
        Message req = DefaultServletTranscoder.getMessage(route, transcoder);
        Channel chan = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.headerConverter.toMetadata(request.headers().asHttpHeaders()))});
        ClientCall<Object, Object> call = DefaultServletTranscoder.getCall(chan, route);
        return ServerResponse.sse(sse -> {
            sse.onError(t -> call.cancel("SSE error", null));
            ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)req, (StreamObserver)new StreamObserver<Object>(){

                public void onNext(Object value) {
                    String json = JsonUtil.toJson(transcoder.out((Message)value, route.httpRule()));
                    sse.data((Object)json);
                }

                public void onError(Throwable t) {
                    if (t instanceof StatusRuntimeException) {
                        StatusRuntimeException sre = (StatusRuntimeException)t;
                        sse.error((Throwable)((Object)new TranscodingRuntimeException((HttpStatusCode)TranscodingUtil.toHttpStatus(sre.getStatus()), sre.getMessage(), null)));
                    } else {
                        sse.error(t);
                    }
                }

                public void onCompleted() {
                    sse.complete();
                }
            });
        }, (Duration)Duration.ZERO);
    }

    private static Message getMessage(Util.Route<?> route, Transcoder transcoder) {
        try {
            return Util.buildRequestMessage(transcoder, route);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        Util.shutdown(this.channel, Duration.ofSeconds(15L));
    }
}

