/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import grpcstarter.extensions.transcoding.HeaderConverter;
import grpcstarter.extensions.transcoding.TranscodingExceptionResolver;
import grpcstarter.extensions.transcoding.TranscodingRuntimeException;
import grpcstarter.extensions.transcoding.TranscodingUtil;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.function.ServerResponse;

public class DefaultTranscodingExceptionResolver
implements TranscodingExceptionResolver {
    private final HeaderConverter headerConverter;

    public DefaultTranscodingExceptionResolver(HeaderConverter headerConverter) {
        this.headerConverter = headerConverter;
    }

    @Override
    public ServerResponse resolve(StatusRuntimeException exception) {
        Metadata trailers = exception.getTrailers();
        throw new TranscodingRuntimeException((HttpStatusCode)TranscodingUtil.toHttpStatus(exception.getStatus()), exception.getMessage(), trailers != null ? this.headerConverter.toHttpHeaders(trailers) : null);
    }
}

