/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.google.protobuf.util.JsonFormat;
import grpcstarter.extensions.transcoding.DefaultHeaderConverter;
import grpcstarter.extensions.transcoding.DefaultReactiveTranscoder;
import grpcstarter.extensions.transcoding.DefaultReactiveTranscodingExceptionResolver;
import grpcstarter.extensions.transcoding.DefaultServletTranscoder;
import grpcstarter.extensions.transcoding.DefaultTranscodingExceptionResolver;
import grpcstarter.extensions.transcoding.GrpcTranscodingBeanFactoryInitializationAotProcessor;
import grpcstarter.extensions.transcoding.GrpcTranscodingProperties;
import grpcstarter.extensions.transcoding.HeaderConverter;
import grpcstarter.extensions.transcoding.JsonUtil;
import grpcstarter.extensions.transcoding.ReactiveTranscoder;
import grpcstarter.extensions.transcoding.ReactiveTranscodingExceptionResolver;
import grpcstarter.extensions.transcoding.ServletTranscoder;
import grpcstarter.extensions.transcoding.TranscodingExceptionResolver;
import grpcstarter.server.ConditionOnGrpcServerEnabled;
import grpcstarter.server.GrpcServerProperties;
import io.grpc.BindableService;
import io.grpc.Metadata;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Metadata.class, HttpHeaders.class, GrpcServerProperties.class})
@ConditionOnGrpcServerEnabled
@ConditionalOnProperty(prefix="grpc.transcoding", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GrpcTranscodingProperties.class})
public class GrpcTranscodingAutoConfiguration
implements SmartInitializingSingleton {
    private final GrpcTranscodingProperties transcodingProperties;

    public GrpcTranscodingAutoConfiguration(GrpcTranscodingProperties transcodingProperties) {
        this.transcodingProperties = transcodingProperties;
    }

    public void afterSingletonsInstantiated() {
        this.setPrinter();
    }

    private void setPrinter() {
        JsonFormat.Printer printer = JsonFormat.printer();
        GrpcTranscodingProperties.PrintOptions printOptions = this.transcodingProperties.getPrintOptions();
        if (printOptions != null) {
            if (!printOptions.isAddWhitespace()) {
                printer = printer.omittingInsignificantWhitespace();
            }
            if (printOptions.isAlwaysPrintEnumsAsInts()) {
                printer = printer.printingEnumsAsInts();
            }
        }
        JsonUtil.setPrinter(printer);
    }

    @Bean
    @ConditionalOnMissingBean
    public HeaderConverter defaultGrpcTranscodingHeaderConverter() {
        return new DefaultHeaderConverter();
    }

    @Bean
    static GrpcTranscodingBeanFactoryInitializationAotProcessor grpcTranscodingBeanFactoryInitializationAotProcessor() {
        return new GrpcTranscodingBeanFactoryInitializationAotProcessor();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class WebFlux {
        WebFlux() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveTranscodingExceptionResolver.class})
        public DefaultReactiveTranscodingExceptionResolver defaultReactiveTranscodingExceptionResolver(HeaderConverter headerConverter) {
            return new DefaultReactiveTranscodingExceptionResolver(headerConverter);
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveTranscoder.class})
        public DefaultReactiveTranscoder grpcStarterDefaultReactiveTranscoder(List<BindableService> services, HeaderConverter headerConverter, GrpcTranscodingProperties grpcTranscodingProperties, GrpcServerProperties grpcServerProperties, ReactiveTranscodingExceptionResolver transcodingExceptionResolver) {
            return new DefaultReactiveTranscoder(services, headerConverter, grpcTranscodingProperties, grpcServerProperties, transcodingExceptionResolver);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class WebMvc {
        WebMvc() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TranscodingExceptionResolver.class})
        public DefaultTranscodingExceptionResolver defaultTranscodingExceptionResolver(HeaderConverter headerConverter) {
            return new DefaultTranscodingExceptionResolver(headerConverter);
        }

        @Bean
        @ConditionalOnMissingBean(value={ServletTranscoder.class})
        public DefaultServletTranscoder grpcStarterDefaultServletTranscoder(List<BindableService> services, HeaderConverter headerConverter, GrpcTranscodingProperties grpcTranscodingProperties, GrpcServerProperties grpcServerProperties, TranscodingExceptionResolver transcodingExceptionResolver) {
            return new DefaultServletTranscoder(services, headerConverter, grpcTranscodingProperties, grpcServerProperties, transcodingExceptionResolver);
        }
    }
}

