/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ClassUtils;

class GrpcTranscodingBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor,
EnvironmentAware {
    private Environment env;

    GrpcTranscodingBeanFactoryInitializationAotProcessor() {
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    @Nullable
    public BeanFactoryInitializationAotContribution processAheadOfTime(@Nonnull ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            Boolean enabled = (Boolean)this.env.getProperty("grpc.transcoding.enabled", Boolean.class, (Object)true);
            if (!enabled.booleanValue()) {
                return;
            }
            ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
            reflection.registerType(HttpHeaders.class, builder -> builder.withMembers(new MemberCategory[]{MemberCategory.PUBLIC_FIELDS}));
            GrpcTranscodingBeanFactoryInitializationAotProcessor.registerReflectionForClassAndInnerClasses(reflection, DescriptorProtos.class);
            GrpcTranscodingBeanFactoryInitializationAotProcessor.registerReflectionForMessages(reflection, GrpcTranscodingBeanFactoryInitializationAotProcessor.getMessages(GrpcTranscodingBeanFactoryInitializationAotProcessor.listGrpcServiceDefinition(beanFactory)));
        };
    }

    private static void registerReflectionForClassAndInnerClasses(ReflectionHints reflection, Class<?> clz) {
        reflection.registerType(clz, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS});
        for (Class<?> declaredClass : clz.getDeclaredClasses()) {
            GrpcTranscodingBeanFactoryInitializationAotProcessor.registerReflectionForClassAndInnerClasses(reflection, declaredClass);
        }
    }

    private static LinkedHashSet<Class<?>> getMessages(Map<String, BeanDefinition> beanNameToBeanDefinition) {
        LinkedHashSet messages = new LinkedHashSet();
        for (Map.Entry<String, BeanDefinition> entry : beanNameToBeanDefinition.entrySet()) {
            Method[] methods;
            BeanDefinition beanDefinition = entry.getValue();
            Class clz = beanDefinition.getResolvableType().resolve();
            if (clz == null) continue;
            for (Method method : methods = clz.getMethods()) {
                Class message2;
                Type type;
                ParameterizedType pt;
                Type[] typeArgs;
                Type arg2;
                Class<?> message1;
                Class<?> returnType = method.getReturnType();
                if (returnType != Void.TYPE || method.getParameterCount() != 2 || !Message.class.isAssignableFrom(message1 = method.getParameterTypes()[0]) || !((arg2 = method.getGenericParameterTypes()[1]) instanceof ParameterizedType) || (typeArgs = (pt = (ParameterizedType)arg2).getActualTypeArguments()).length != 1 || !((type = typeArgs[0]) instanceof Class) || !Message.class.isAssignableFrom(message2 = (Class)type)) continue;
                messages.add(message1);
                messages.add(message2);
            }
        }
        return messages;
    }

    private static void registerReflectionForMessages(ReflectionHints reflection, Set<Class<?>> messages) {
        for (Class<?> message : messages) {
            reflection.registerType(message, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS});
            Class<?> builderClass = GrpcTranscodingBeanFactoryInitializationAotProcessor.getBuilderClass(message);
            if (builderClass == null) continue;
            reflection.registerType(builderClass, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS});
        }
    }

    private static Class<?> getBuilderClass(Class<?> message) {
        try {
            return ClassUtils.forName((String)(message.getName() + "$Builder"), null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Map<String, BeanDefinition> listGrpcServiceDefinition(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
            Class clz = beanDefinition.getResolvableType().resolve();
            if (clz == null || !BindableService.class.isAssignableFrom(clz)) continue;
            beanDefinitions.put(name, beanDefinition);
        }
        return beanDefinitions;
    }
}

