/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import grpcstarter.extensions.transcoding.Util;
import java.io.IOException;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

final class JsonUtil {
    private static final ObjectMapper om = new Jackson2ObjectMapperBuilder().failOnEmptyBeans(false).modules(new Module[]{new SimpleModule().addSerializer((JsonSerializer)new ProtoMessageSerializer())}).build();
    private static JsonFormat.Printer printer;

    public static String toJson(Object obj) {
        if (obj instanceof Message) {
            Message m = (Message)obj;
            if (Util.isSimpleValueMessage(m)) {
                return Util.stringifySimpleValueMessage(m);
            }
            try {
                return JsonUtil.getPrinter().print((MessageOrBuilder)m);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (BeanUtils.isSimpleValueType(obj.getClass())) {
            return String.valueOf(obj);
        }
        try {
            return om.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean canParseJson(Object obj) {
        if (obj instanceof Message) {
            Message m = (Message)obj;
            return !Util.isSimpleValueMessage(m);
        }
        return !BeanUtils.isSimpleValueType(obj.getClass());
    }

    public static void setPrinter(JsonFormat.Printer printer) {
        JsonUtil.printer = printer;
    }

    private static JsonFormat.Printer getPrinter() {
        if (printer == null) {
            printer = JsonFormat.printer().omittingInsignificantWhitespace();
        }
        return printer;
    }

    @Generated
    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class ProtoMessageSerializer
    extends StdSerializer<MessageOrBuilder> {
        private ProtoMessageSerializer() {
            super(MessageOrBuilder.class);
        }

        public void serialize(MessageOrBuilder value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(JsonUtil.getPrinter().print(value));
        }
    }
}

