/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import grpcstarter.extensions.transcoding.Util;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ProtobufJavaTypeUtil {
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Map<String, Map<String, Type>> fieldTypeCache = new ConcurrentHashMap<String, Map<String, Type>>();

    private ProtobufJavaTypeUtil() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static Class<?> findJavaClass(Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("Message descriptor cannot be null");
        }
        String fullName = messageDescriptor.getFullName();
        return classCache.computeIfAbsent(fullName, k -> ProtobufJavaTypeUtil.doFindJavaClass(messageDescriptor));
    }

    public static Type findJavaFieldType(Class<?> javaClass, Descriptors.FieldDescriptor fieldDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException("Java class cannot be null");
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException("Field descriptor cannot be null");
        }
        return fieldTypeCache.computeIfAbsent(javaClass.getName(), k -> new ConcurrentHashMap()).computeIfAbsent(fieldDescriptor.getName(), k -> ProtobufJavaTypeUtil.findGetterReturnType(javaClass, fieldDescriptor));
    }

    private static Class<?> doFindJavaClass(Descriptors.Descriptor descriptor) {
        DescriptorProtos.FileOptions options = descriptor.getFile().getOptions();
        String javaPackage = options.hasJavaPackage() ? options.getJavaPackage() : descriptor.getFile().getPackage();
        ArrayList<Object> classNames = new ArrayList<Object>(2);
        if (options.getJavaMultipleFiles()) {
            classNames.add(javaPackage + "." + ProtobufJavaTypeUtil.getSimpleClassName(descriptor));
        } else if (options.hasJavaOuterClassname()) {
            classNames.add(javaPackage + "." + options.getJavaOuterClassname() + "$" + ProtobufJavaTypeUtil.getSimpleClassName(descriptor));
        } else {
            String name = descriptor.getFile().getName();
            String fileName = name.substring(name.lastIndexOf(47) + 1);
            String string = ProtobufJavaTypeUtil.underlineToPascal(fileName.replace(".proto", ""));
            classNames.add(String.format("%s.%sOuterClass$%s", javaPackage, string, ProtobufJavaTypeUtil.getSimpleClassName(descriptor)));
            classNames.add(String.format("%s.%s$%s", javaPackage, string, ProtobufJavaTypeUtil.getSimpleClassName(descriptor)));
        }
        Class<?> clazz = null;
        for (String string : classNames) {
            try {
                clazz = Class.forName(string);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (clazz == null) {
            throw new IllegalStateException("Unable to find Java class for protobuf message type: " + String.valueOf(classNames) + " (descriptor: " + descriptor.getFullName() + ")");
        }
        return clazz;
    }

    private static Type findGetterReturnType(Class<?> javaClass, Descriptors.FieldDescriptor fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        String getterMethodName = fieldDescriptor.isMapField() ? "get" + ProtobufJavaTypeUtil.underlineToPascal(fieldName) + "Map" : (fieldDescriptor.isRepeated() ? "get" + ProtobufJavaTypeUtil.underlineToPascal(fieldName) + "List" : "get" + ProtobufJavaTypeUtil.underlineToPascal(fieldName));
        try {
            Method getterMethod = javaClass.getMethod(getterMethodName, new Class[0]);
            return getterMethod.getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getSimpleClassName(Descriptors.Descriptor descriptor) {
        return Util.getClassName(descriptor);
    }

    private static String underlineToCamel(String name) {
        StringBuilder sb = new StringBuilder();
        int len = name.length();
        int end = len - 1;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '_' && i < end) {
                sb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String underlineToPascal(String name) {
        String n = ProtobufJavaTypeUtil.underlineToCamel(name);
        if (n.isBlank()) {
            return n;
        }
        return Character.toUpperCase(n.charAt(0)) + n.substring(1);
    }
}

