/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.google.api.HttpRule;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class Transcoder {
    private static JsonFormat.Parser parser;
    private final Variable variable;

    private Transcoder(Variable variable) {
        this.variable = variable;
    }

    public static Transcoder create(Variable variable) {
        return new Transcoder(variable);
    }

    public void into(@Nonnull Message.Builder messageBuilder, @Nonnull HttpRule httpRule) throws InvalidProtocolBufferException {
        Map<String, String> pathVariables;
        Map<String, String[]> parameters;
        Optional<String> bodyStringOpt;
        if (!httpRule.getBody().isBlank() && (bodyStringOpt = Optional.ofNullable(this.variable.body()).map(e -> new String((byte[])e, StandardCharsets.UTF_8)).filter(e -> !e.isBlank())).isPresent()) {
            if (Objects.equals(httpRule.getBody(), "*")) {
                Transcoder.merge(messageBuilder, bodyStringOpt.get());
            } else {
                Message.Builder fieldBuilder;
                Descriptors.FieldDescriptor field = messageBuilder.getDescriptorForType().findFieldByName(httpRule.getBody());
                if (Transcoder.hasBuilder(field) && (fieldBuilder = messageBuilder.getFieldBuilder(field)) != null) {
                    Transcoder.merge(fieldBuilder, bodyStringOpt.get());
                }
            }
        }
        if ((parameters = this.variable.parameters()) != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String[] values = entry.getValue();
                String[] fieldPath = key.split("\\.");
                Message.Builder lastBuilder = messageBuilder;
                for (int i = 0; i < fieldPath.length - 1; ++i) {
                    Descriptors.FieldDescriptor field = lastBuilder.getDescriptorForType().findFieldByName(fieldPath[i]);
                    if (!Transcoder.hasBuilder(field)) continue;
                    lastBuilder = lastBuilder.getFieldBuilder(field);
                }
                Descriptors.FieldDescriptor field = lastBuilder.getDescriptorForType().findFieldByName(fieldPath[fieldPath.length - 1]);
                if (!Transcoder.isValueType(field)) continue;
                if (field.isRepeated()) {
                    for (String value : values) {
                        lastBuilder.addRepeatedField(field, Transcoder.parseValue(field, value));
                    }
                    continue;
                }
                if (values.length <= 0 || lastBuilder.hasField(field)) continue;
                Transcoder.setValueField(lastBuilder, field, values[0]);
            }
        }
        if ((pathVariables = this.variable.pathVariables()) != null && !pathVariables.isEmpty()) {
            for (Map.Entry<String, String> entry : pathVariables.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Descriptors.FieldDescriptor field = messageBuilder.getDescriptorForType().findFieldByName(key);
                if (!Transcoder.isValueType(field)) continue;
                Transcoder.setValueField(messageBuilder, field, value);
            }
        }
    }

    public Object out(@Nonnull Message response, @Nonnull HttpRule httpRule) {
        Descriptors.FieldDescriptor field;
        if (!httpRule.getResponseBody().isBlank() && (field = response.getDescriptorForType().findFieldByName(httpRule.getResponseBody())) != null) {
            return response.getField(field);
        }
        return response;
    }

    private static void merge(Message.Builder messageBuilder, String bodyString) throws InvalidProtocolBufferException {
        Transcoder.getParser().merge(bodyString, messageBuilder);
    }

    private static boolean hasBuilder(Descriptors.FieldDescriptor field) {
        return field != null && !field.isRepeated() && !field.isMapField() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE;
    }

    private static void setValueField(Message.Builder lastBuilder, Descriptors.FieldDescriptor field, String values) {
        if (lastBuilder == null || field == null || values == null) {
            return;
        }
        if (Transcoder.isValueType(field)) {
            lastBuilder.setField(field, Transcoder.parseValue(field, values));
        }
    }

    private static boolean isValueType(Descriptors.FieldDescriptor field) {
        boolean bl;
        block4: {
            block3: {
                if (field == null) break block3;
                switch (field.getJavaType()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BOOLEAN: 
                    case STRING: 
                    case BYTE_STRING: 
                    case ENUM: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object parseValue(Descriptors.FieldDescriptor field, String value) {
        switch (field.getJavaType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INT: {
                Integer n = Integer.parseInt(value);
                Object object = n;
                return object;
            }
            case LONG: {
                Long l = Long.parseLong(value);
                Object object = l;
                return object;
            }
            case FLOAT: {
                Float f = Float.valueOf(Float.parseFloat(value));
                Object object = f;
                return object;
            }
            case DOUBLE: {
                Double d = Double.parseDouble(value);
                Object object = d;
                return object;
            }
            case BOOLEAN: {
                Boolean bl = Boolean.parseBoolean(value);
                Object object = bl;
                return object;
            }
            case STRING: {
                String string = value;
                Object object = string;
                return object;
            }
            case BYTE_STRING: {
                ByteString byteString = ByteString.copyFrom((byte[])value.getBytes(StandardCharsets.UTF_8));
                Object object = byteString;
                return object;
            }
            case ENUM: {
                Object object;
                if (value.isBlank()) {
                    Descriptors.EnumValueDescriptor enumValueDescriptor = (Descriptors.EnumValueDescriptor)field.getEnumType().getValues().get(0);
                    object = enumValueDescriptor;
                    return object;
                }
                if (Character.isDigit(value.charAt(0))) {
                    try {
                        Descriptors.EnumValueDescriptor e = field.getEnumType().findValueByNumber(Integer.parseInt(value));
                        if (e == null) throw new IllegalArgumentException("Can't parse enum value '" + value + "' for field '" + field.getName() + "'");
                        Descriptors.EnumValueDescriptor enumValueDescriptor = e;
                        object = enumValueDescriptor;
                        return object;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Can't parse enum value '" + value + "' for field '" + field.getName() + "'");
                    }
                } else {
                    Descriptors.EnumValueDescriptor e = field.getEnumType().findValueByName(value);
                    if (e == null) throw new IllegalArgumentException("Can't parse enum value '" + value + "' for field '" + field.getName() + "'");
                    Descriptors.EnumValueDescriptor enumValueDescriptor = e;
                    object = enumValueDescriptor;
                    return object;
                }
            }
            case MESSAGE: {
                throw new IllegalArgumentException("Direct parsing to message type not supported, field " + field.getName());
            }
        }
    }

    private static JsonFormat.Parser getParser() {
        if (parser == null) {
            parser = JsonFormat.parser().ignoringUnknownFields();
        }
        return parser;
    }

    public record Variable(byte[] body, Map<String, String[]> parameters, Map<String, String> pathVariables) {
    }
}

