/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import io.grpc.Status;
import lombok.Generated;
import org.springframework.http.HttpStatus;

public final class TranscodingUtil {
    public static HttpStatus toHttpStatus(Status grpcStatus) {
        return switch (grpcStatus.getCode()) {
            case Status.Code.OK -> HttpStatus.OK;
            case Status.Code.CANCELLED -> HttpStatus.BAD_REQUEST;
            case Status.Code.UNKNOWN -> HttpStatus.INTERNAL_SERVER_ERROR;
            case Status.Code.INVALID_ARGUMENT -> HttpStatus.BAD_REQUEST;
            case Status.Code.DEADLINE_EXCEEDED -> HttpStatus.GATEWAY_TIMEOUT;
            case Status.Code.NOT_FOUND -> HttpStatus.NOT_FOUND;
            case Status.Code.ALREADY_EXISTS -> HttpStatus.CONFLICT;
            case Status.Code.PERMISSION_DENIED -> HttpStatus.FORBIDDEN;
            case Status.Code.RESOURCE_EXHAUSTED -> HttpStatus.TOO_MANY_REQUESTS;
            case Status.Code.FAILED_PRECONDITION -> HttpStatus.BAD_REQUEST;
            case Status.Code.ABORTED -> HttpStatus.CONFLICT;
            case Status.Code.OUT_OF_RANGE -> HttpStatus.BAD_REQUEST;
            case Status.Code.UNIMPLEMENTED -> HttpStatus.NOT_IMPLEMENTED;
            case Status.Code.INTERNAL -> HttpStatus.INTERNAL_SERVER_ERROR;
            case Status.Code.UNAVAILABLE -> HttpStatus.SERVICE_UNAVAILABLE;
            case Status.Code.DATA_LOSS -> HttpStatus.INTERNAL_SERVER_ERROR;
            case Status.Code.UNAUTHENTICATED -> HttpStatus.UNAUTHORIZED;
            default -> HttpStatus.INTERNAL_SERVER_ERROR;
        };
    }

    @Generated
    private TranscodingUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

