/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.transcoding;

import com.google.api.AnnotationsProto;
import com.google.api.HttpRule;
import com.google.api.pathtemplate.PathTemplate;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import grpcstarter.extensions.transcoding.GrpcTranscodingProperties;
import grpcstarter.extensions.transcoding.ProtobufJavaTypeUtil;
import grpcstarter.extensions.transcoding.Transcoder;
import grpcstarter.server.GrpcServerProperties;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.server.ServerRequest;

final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = String.valueOf(Util.class) + ".matchingPattern";
    private static final HttpRule defaultHttpRule = HttpRule.newBuilder().setBody("*").build();
    static final Map<String, Message> methodCache = new ConcurrentReferenceHashMap();

    private static <T> List<Route<T>> fillRoutes(Map<String, Route<T>> autoMappingRoutes, List<Route<T>> customRoutes, List<ServerServiceDefinition> definitions, BiFunction<HttpMethod, PathTemplate, Predicate<T>> predicateCreator, GrpcTranscodingProperties grpcTranscodingProperties) {
        for (ServerServiceDefinition ssd : definitions) {
            Descriptors.ServiceDescriptor serviceDescriptor = Util.getServiceDescriptor(ssd);
            if (serviceDescriptor == null) continue;
            Map methodNameToMethodDescriptor = serviceDescriptor.getMethods().stream().collect(Collectors.toMap(Descriptors.MethodDescriptor::getName, Function.identity()));
            ssd.getMethods().stream().map(ServerMethodDefinition::getMethodDescriptor).forEach(invokeMethod -> {
                Descriptors.MethodDescriptor methodDescriptor = (Descriptors.MethodDescriptor)methodNameToMethodDescriptor.get(invokeMethod.getBareMethodName());
                if (methodDescriptor == null) {
                    return;
                }
                boolean hasHttpExtension = methodDescriptor.getOptions().hasExtension(AnnotationsProto.http);
                if (hasHttpExtension) {
                    HttpRule httpRule = (HttpRule)methodDescriptor.getOptions().getExtension(AnnotationsProto.http);
                    Optional.ofNullable(Util.createRouteWithBindings(httpRule, invokeMethod, methodDescriptor, predicateCreator)).ifPresent(customRoutes::add);
                } else if (grpcTranscodingProperties.isAutoMapping()) {
                    autoMappingRoutes.put(invokeMethod.getFullMethodName(), new Route<Object>(defaultHttpRule, (MethodDescriptor<?, ?>)invokeMethod, methodDescriptor, t -> false, List.of()));
                }
            });
        }
        return customRoutes;
    }

    @Nullable
    private static <T> Route<T> createRouteWithBindings(HttpRule httpRule, MethodDescriptor<?, ?> invokeMethod, Descriptors.MethodDescriptor methodDescriptor, BiFunction<HttpMethod, PathTemplate, Predicate<T>> predicateCreator) {
        ArrayList additionalPredicates = new ArrayList();
        for (HttpRule binding : httpRule.getAdditionalBindingsList()) {
            HttpMethod method = Util.extractHttpMethod(binding);
            String path = Util.extractPath(binding);
            if (method == null || path == null) continue;
            additionalPredicates.add(predicateCreator.apply(method, PathTemplate.create((String)path)));
        }
        HttpMethod mainMethod = Util.extractHttpMethod(httpRule);
        String mainPath = Util.extractPath(httpRule);
        if (mainMethod != null && mainPath != null) {
            Predicate<T> mainPredicate = predicateCreator.apply(mainMethod, PathTemplate.create((String)mainPath));
            return new Route<T>(httpRule, invokeMethod, methodDescriptor, mainPredicate, additionalPredicates);
        }
        return null;
    }

    @Nullable
    private static HttpMethod extractHttpMethod(HttpRule httpRule) {
        return switch (httpRule.getPatternCase()) {
            case HttpRule.PatternCase.GET -> HttpMethod.GET;
            case HttpRule.PatternCase.PUT -> HttpMethod.PUT;
            case HttpRule.PatternCase.POST -> HttpMethod.POST;
            case HttpRule.PatternCase.DELETE -> HttpMethod.DELETE;
            case HttpRule.PatternCase.PATCH -> HttpMethod.PATCH;
            case HttpRule.PatternCase.CUSTOM -> HttpMethod.valueOf((String)httpRule.getCustom().getKind());
            case HttpRule.PatternCase.PATTERN_NOT_SET -> null;
            default -> throw new IllegalArgumentException("Unsupported HTTP method: " + String.valueOf(httpRule.getPatternCase()));
        };
    }

    @Nullable
    private static String extractPath(HttpRule httpRule) {
        return switch (httpRule.getPatternCase()) {
            case HttpRule.PatternCase.GET -> httpRule.getGet();
            case HttpRule.PatternCase.PUT -> httpRule.getPut();
            case HttpRule.PatternCase.POST -> httpRule.getPost();
            case HttpRule.PatternCase.DELETE -> httpRule.getDelete();
            case HttpRule.PatternCase.PATCH -> httpRule.getPatch();
            case HttpRule.PatternCase.CUSTOM -> httpRule.getCustom().getPath();
            case HttpRule.PatternCase.PATTERN_NOT_SET -> null;
            default -> throw new IllegalArgumentException("Unsupported HTTP pattern: " + String.valueOf(httpRule.getPatternCase()));
        };
    }

    public static List<ServerServiceDefinition> listDefinition(List<BindableService> services) {
        return services.stream().map(BindableService::bindService).toList();
    }

    public static List<Route<org.springframework.web.servlet.function.ServerRequest>> fillRoutes(List<BindableService> services, Map<String, Route<org.springframework.web.servlet.function.ServerRequest>> autoMappingRoutes, List<Route<org.springframework.web.servlet.function.ServerRequest>> customRoutes, GrpcTranscodingProperties grpcTranscodingProperties) {
        return Util.fillRoutes(autoMappingRoutes, customRoutes, Util.listDefinition(services), ServletPredicate::new, grpcTranscodingProperties);
    }

    public static List<Route<ServerRequest>> getReactiveRoutes(List<BindableService> services, Map<String, Route<ServerRequest>> autoMappingRoutes, List<Route<ServerRequest>> customRoutes, GrpcTranscodingProperties grpcTranscodingProperties) {
        return Util.fillRoutes(autoMappingRoutes, customRoutes, Util.listDefinition(services), ReactivePredicate::new, grpcTranscodingProperties);
    }

    static String snakeToPascal(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        boolean toUpperCase = true;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                toUpperCase = true;
                continue;
            }
            result.append(toUpperCase ? Character.toUpperCase(c) : c);
            toUpperCase = false;
        }
        return result.toString();
    }

    @Nullable
    private static Descriptors.ServiceDescriptor getServiceDescriptor(ServerServiceDefinition definition) {
        Object schemaDescriptor = definition.getServiceDescriptor().getSchemaDescriptor();
        if (schemaDescriptor instanceof ProtoFileDescriptorSupplier) {
            ProtoFileDescriptorSupplier protoFileDescriptorSupplier = (ProtoFileDescriptorSupplier)schemaDescriptor;
            Descriptors.FileDescriptor fileDescriptor = protoFileDescriptorSupplier.getFileDescriptor();
            String serviceName = definition.getServiceDescriptor().getName();
            return fileDescriptor.getServices().stream().filter(serviceDescriptor -> serviceDescriptor.getFullName().equals(serviceName)).findFirst().orElseThrow();
        }
        return null;
    }

    static Message getDefaultMessage(Descriptors.Descriptor descriptor) {
        Class<?> javaClass = ProtobufJavaTypeUtil.findJavaClass(descriptor);
        try {
            Method defaultInstance = javaClass.getMethod("getDefaultInstance", new Class[0]);
            return (Message)defaultInstance.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Invalid Protobuf Message type: no invocable getDefaultInstance() method on " + javaClass.getName(), ex);
        }
    }

    public static String getClassName(Descriptors.Descriptor descriptor) {
        Object className = "";
        while (descriptor != null) {
            className = descriptor.getName() + (String)(StringUtils.hasText((String)className) ? "$" + (String)className : "");
            descriptor = descriptor.getContainingType();
        }
        return className;
    }

    public static Channel getTranscodingChannel(int port, GrpcTranscodingProperties grpcTranscodingProperties, GrpcServerProperties grpcServerProperties) {
        GrpcServerProperties.InProcess inProcess = grpcServerProperties.getInProcess();
        if (inProcess != null && StringUtils.hasText((String)inProcess.getName())) {
            InProcessChannelBuilder builder = InProcessChannelBuilder.forName((String)inProcess.getName());
            Util.populateChannel(builder, grpcServerProperties);
            return builder.build();
        }
        Object endpoint = StringUtils.hasText((String)grpcTranscodingProperties.getEndpoint()) ? grpcTranscodingProperties.getEndpoint() : "localhost:" + port;
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)endpoint);
        Util.populateChannel(builder, grpcServerProperties);
        if (grpcServerProperties.getTls() == null) {
            builder.usePlaintext();
        }
        return builder.build();
    }

    private static ManagedChannelBuilder<? extends ManagedChannelBuilder<?>> populateChannel(ManagedChannelBuilder<? extends ManagedChannelBuilder<?>> channelBuilder, GrpcServerProperties grpcServerProperties) {
        Optional.ofNullable(grpcServerProperties.getMaxInboundMessageSize()).map(DataSize::toBytes).map(Long::intValue).ifPresent(arg_0 -> channelBuilder.maxInboundMessageSize(arg_0));
        Optional.ofNullable(grpcServerProperties.getMaxInboundMetadataSize()).map(DataSize::toBytes).map(Long::intValue).ifPresent(arg_0 -> channelBuilder.maxInboundMetadataSize(arg_0));
        return channelBuilder;
    }

    public static Message buildRequestMessage(Transcoder transcoder, Route<?> route) throws InvalidProtocolBufferException {
        Message.Builder messageBuilder = methodCache.computeIfAbsent(route.methodDescriptor().getInputType().getFullName(), k -> Util.getDefaultMessage(route.methodDescriptor().getInputType())).toBuilder();
        transcoder.into(messageBuilder, route.httpRule());
        return messageBuilder.build();
    }

    public static void shutdown(Channel channel, Duration timeout) {
        ManagedChannel mc;
        if (!(channel instanceof ManagedChannel) || (mc = (ManagedChannel)channel).isShutdown() || mc.isTerminated()) {
            return;
        }
        long ms = timeout.toMillis();
        try {
            mc.shutdown();
            if (!mc.awaitTermination(ms, TimeUnit.MILLISECONDS)) {
                log.warn("Graceful shutdown timed out: {}ms, channel: {}", (Object)ms, (Object)mc);
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted gracefully shutting down channel: {}", (Object)mc);
            Thread.currentThread().interrupt();
        }
        if (!mc.isTerminated()) {
            try {
                mc.shutdownNow();
                if (!mc.awaitTermination(15L, TimeUnit.SECONDS)) {
                    log.warn("Forcefully shutdown timed out: 15s, channel: {}. ", (Object)mc);
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted forcefully shutting down channel: {}. ", (Object)mc);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean isSimpleValueMessage(Message message) {
        if (Util.isWrapperType(message.getClass())) {
            return true;
        }
        if (message instanceof Value) {
            Value value = (Value)message;
            Value.KindCase kind = value.getKindCase();
            return kind == Value.KindCase.NULL_VALUE || kind == Value.KindCase.NUMBER_VALUE || kind == Value.KindCase.STRING_VALUE || kind == Value.KindCase.BOOL_VALUE;
        }
        return false;
    }

    public static String stringifySimpleValueMessage(Message message) {
        if (message instanceof BoolValue) {
            BoolValue boolValue = (BoolValue)message;
            return String.valueOf(boolValue.getValue());
        }
        if (message instanceof Int32Value) {
            Int32Value int32Value = (Int32Value)message;
            return String.valueOf(int32Value.getValue());
        }
        if (message instanceof Int64Value) {
            Int64Value int64Value = (Int64Value)message;
            return String.valueOf(int64Value.getValue());
        }
        if (message instanceof UInt32Value) {
            UInt32Value uInt32Value = (UInt32Value)message;
            return String.valueOf(uInt32Value.getValue());
        }
        if (message instanceof UInt64Value) {
            UInt64Value uInt64Value = (UInt64Value)message;
            return String.valueOf(uInt64Value.getValue());
        }
        if (message instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)message;
            return String.valueOf(floatValue.getValue());
        }
        if (message instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)message;
            return String.valueOf(doubleValue.getValue());
        }
        if (message instanceof StringValue) {
            StringValue stringValue = (StringValue)message;
            return stringValue.getValue();
        }
        if (message instanceof BytesValue) {
            BytesValue bytesValue = (BytesValue)message;
            return bytesValue.getValue().toStringUtf8();
        }
        if (message instanceof Value) {
            Value value = (Value)message;
            return switch (value.getKindCase()) {
                case Value.KindCase.NULL_VALUE -> "null";
                case Value.KindCase.NUMBER_VALUE -> String.valueOf(value.getNumberValue());
                case Value.KindCase.STRING_VALUE -> value.getStringValue();
                case Value.KindCase.BOOL_VALUE -> String.valueOf(value.getBoolValue());
                default -> null;
            };
        }
        return null;
    }

    private static boolean isWrapperType(Class<?> clz) {
        return BoolValue.class.isAssignableFrom(clz) || Int32Value.class.isAssignableFrom(clz) || Int64Value.class.isAssignableFrom(clz) || UInt32Value.class.isAssignableFrom(clz) || UInt64Value.class.isAssignableFrom(clz) || FloatValue.class.isAssignableFrom(clz) || DoubleValue.class.isAssignableFrom(clz) || StringValue.class.isAssignableFrom(clz) || BytesValue.class.isAssignableFrom(clz);
    }

    private static boolean isMatch(HttpMethod requestMethod, HttpMethod httpMethod, @Nonnull String path, PathTemplate pathTemplate, Map<String, Object> attributes) {
        if (!Objects.equals(requestMethod, httpMethod)) {
            return false;
        }
        if ((path = Util.trim(path, '/')).contains(":") && !pathTemplate.endsWithCustomVerb()) {
            return false;
        }
        Map result = pathTemplate.match(path);
        if (result == null) {
            return false;
        }
        attributes.put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, result);
        return true;
    }

    static String trim(String str, char c) {
        int start;
        if (str == null || str.isEmpty()) {
            return str;
        }
        int end = str.length();
        for (start = 0; start < end && str.charAt(start) == c; ++start) {
        }
        while (end > start && str.charAt(end - 1) == c) {
            --end;
        }
        return str.substring(start, end);
    }

    @Generated
    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    record Route<T>(@Nonnull HttpRule httpRule, @Nonnull MethodDescriptor<?, ?> invokeMethod, @Nonnull Descriptors.MethodDescriptor methodDescriptor, @Nonnull Predicate<T> predicate, @Nonnull List<Predicate<T>> additionalPredicates) {
    }

    record ReactivePredicate(HttpMethod httpMethod, PathTemplate pathTemplate) implements Predicate<ServerRequest>
    {
        @Override
        public boolean test(ServerRequest request) {
            return Util.isMatch(request.method(), this.httpMethod, request.path(), this.pathTemplate, request.attributes());
        }
    }

    record ServletPredicate(HttpMethod httpMethod, PathTemplate pathTemplate) implements Predicate<org.springframework.web.servlet.function.ServerRequest>
    {
        @Override
        public boolean test(org.springframework.web.servlet.function.ServerRequest request) {
            return Util.isMatch(request.method(), this.httpMethod, request.path(), this.pathTemplate, request.attributes());
        }
    }
}

