/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.validation;

import build.buf.protovalidate.Validator;
import grpcstarter.client.ConditionOnGrpcClientEnabled;
import grpcstarter.client.GrpcClientProperties;
import grpcstarter.extensions.validation.GrpcValidationProperties;
import grpcstarter.extensions.validation.OrderedValidatingClientInterceptor;
import grpcstarter.extensions.validation.OrderedValidatingServerInterceptor;
import grpcstarter.extensions.validation.ProtoValidateClientInterceptor;
import grpcstarter.extensions.validation.ProtoValidateServerInterceptor;
import grpcstarter.server.ConditionOnGrpcServerEnabled;
import grpcstarter.server.GrpcServerProperties;
import io.envoyproxy.pgv.ReflectiveValidatorIndex;
import io.envoyproxy.pgv.ValidatorIndex;
import io.envoyproxy.pgv.grpc.ValidatingClientInterceptor;
import io.envoyproxy.pgv.grpc.ValidatingServerInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="grpc.validation", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GrpcValidationProperties.class})
public class GrpcValidationAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Validator.class})
    @ConditionalOnProperty(prefix="grpc.validation", name={"backend"}, havingValue="PROTO_VALIDATE", matchIfMissing=true)
    static class ProtoValidate {
        ProtoValidate() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={GrpcServerProperties.class})
        @ConditionOnGrpcServerEnabled
        @ConditionalOnProperty(prefix="grpc.validation.server", name={"enabled"}, matchIfMissing=true)
        static class Server {
            Server() {
            }

            @Bean
            @ConditionalOnMissingBean
            public ProtoValidateServerInterceptor protoValidateServerInterceptor(GrpcValidationProperties properties) {
                return new ProtoValidateServerInterceptor(new Validator(), properties.getServer().getOrder());
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={GrpcClientProperties.class})
        @ConditionOnGrpcClientEnabled
        @ConditionalOnProperty(prefix="grpc.validation.client", name={"enabled"}, matchIfMissing=true)
        static class Client {
            Client() {
            }

            @Bean
            @ConditionalOnMissingBean
            public ProtoValidateClientInterceptor protoValidateClientInterceptor(GrpcValidationProperties properties) {
                return new ProtoValidateClientInterceptor(new Validator(), properties.getClient().getOrder());
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ValidatorIndex.class})
    @ConditionalOnProperty(prefix="grpc.validation", name={"backend"}, havingValue="PGV", matchIfMissing=true)
    static class Pgv {
        Pgv() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ValidatingServerInterceptor.class, GrpcServerProperties.class})
        @ConditionOnGrpcServerEnabled
        @ConditionalOnProperty(prefix="grpc.validation.server", name={"enabled"}, matchIfMissing=true)
        static class Server {
            Server() {
            }

            @Bean
            @ConditionalOnMissingBean
            public ValidatingServerInterceptor grpcValidatingServerInterceptor(GrpcValidationProperties properties) {
                return new OrderedValidatingServerInterceptor((ValidatorIndex)new ReflectiveValidatorIndex(), properties.getServer().getOrder());
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ValidatingClientInterceptor.class, GrpcClientProperties.class})
        @ConditionOnGrpcClientEnabled
        @ConditionalOnProperty(prefix="grpc.validation.client", name={"enabled"}, matchIfMissing=true)
        static class Client {
            Client() {
            }

            @Bean
            @ConditionalOnMissingBean
            public ValidatingClientInterceptor grpcValidatingClientInterceptor(GrpcValidationProperties properties) {
                return new OrderedValidatingClientInterceptor((ValidatorIndex)new ReflectiveValidatorIndex(), properties.getClient().getOrder());
            }
        }
    }
}

