/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.validation;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.Validator;
import build.buf.protovalidate.exceptions.ValidationException;
import com.google.protobuf.Message;
import grpcstarter.extensions.validation.ValidationExceptionUtil;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.MethodDescriptor;
import org.springframework.core.Ordered;

public class ProtoValidateClientInterceptor
implements ClientInterceptor,
Ordered {
    private final Validator validator;
    private final int order;

    public ProtoValidateClientInterceptor(Validator validator, int order) {
        this.validator = validator;
        this.order = order;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void sendMessage(ReqT message) {
                ValidationResult result;
                try {
                    result = ProtoValidateClientInterceptor.this.validator.validate((Message)message);
                }
                catch (ValidationException e) {
                    throw ValidationExceptionUtil.asInternalException(e);
                }
                if (!result.isSuccess()) {
                    throw ValidationExceptionUtil.asInvalidArgumentException(result.getViolations());
                }
                super.sendMessage(message);
            }
        };
    }

    public int getOrder() {
        return this.order;
    }
}

