/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.validation;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.Validator;
import build.buf.protovalidate.exceptions.ValidationException;
import com.google.protobuf.Message;
import grpcstarter.extensions.validation.ValidationExceptionUtil;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.StatusRuntimeException;
import java.util.Optional;
import org.springframework.core.Ordered;

public class ProtoValidateServerInterceptor
implements ServerInterceptor,
Ordered {
    private final Validator validator;
    private final int order;

    public ProtoValidateServerInterceptor(Validator validator, int order) {
        this.validator = validator;
        this.order = order;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){
            private boolean aborted;
            {
                super(delegate);
                this.aborted = false;
            }

            public void onMessage(ReqT message) {
                ValidationResult result;
                try {
                    result = ProtoValidateServerInterceptor.this.validator.validate((Message)message);
                }
                catch (ValidationException e) {
                    this.aborted = true;
                    throw ValidationExceptionUtil.asInternalException(e);
                }
                if (result.isSuccess()) {
                    super.onMessage(message);
                } else {
                    StatusRuntimeException sre = ValidationExceptionUtil.asInvalidArgumentException(result.getViolations());
                    this.aborted = true;
                    call.close(sre.getStatus(), Optional.ofNullable(sre.getTrailers()).orElseGet(Metadata::new));
                }
            }

            public void onHalfClose() {
                if (!this.aborted) {
                    super.onHalfClose();
                }
            }
        };
    }

    public int getOrder() {
        return this.order;
    }
}

