/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.extensions.validation;

import build.buf.protovalidate.exceptions.ValidationException;
import build.buf.validate.Violation;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.StringUtils;

final class ValidationExceptionUtil {
    public static StatusRuntimeException asInternalException(ValidationException ex) {
        return new StatusRuntimeException(Status.INTERNAL.withDescription(ex.getMessage()));
    }

    public static StatusRuntimeException asInvalidArgumentException(List<Violation> violations) {
        String message = violations.stream().map(ValidationExceptionUtil::getErrorMessage).collect(Collectors.joining(", "));
        return new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription(message));
    }

    private static String getErrorMessage(Violation violation) {
        String field = violation.getFieldPath();
        if (StringUtils.hasText((String)field)) {
            return field + ": " + violation.getMessage();
        }
        return violation.getMessage();
    }

    @Generated
    private ValidationExceptionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

