/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.EnableExchangeClients;
import io.github.danielliu1123.httpexchange.HttpClientBeanRegistrar;
import io.github.danielliu1123.httpexchange.HttpExchangeProperties;
import io.github.danielliu1123.httpexchange.Util;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ExchangeClientsRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment environment;
    private HttpExchangeProperties properties;
    private HttpClientBeanRegistrar registrar;

    ExchangeClientsRegistrar() {
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(@Nonnull AnnotationMetadata metadata, @Nonnull BeanDefinitionRegistry registry) {
        boolean enabled = (Boolean)this.environment.getProperty("http-exchange.enabled", Boolean.class, (Object)true);
        if (!enabled) {
            return;
        }
        this.properties = this.properties == null ? Util.getProperties(this.environment) : this.properties;
        this.registrar = this.registrar == null ? new HttpClientBeanRegistrar(registry, this.environment) : this.registrar;
        Map<String, Object> attrs = Optional.ofNullable(metadata.getAnnotationAttributes(EnableExchangeClients.class.getName())).orElse(Map.of());
        String[] basePackages = this.getBasePackages(attrs);
        Class<?>[] clientClasses = this.getClients(attrs);
        if (clientClasses.length > 0) {
            this.registrar.register(clientClasses);
            if (basePackages.length > 0) {
                this.registrar.register(basePackages);
            }
            return;
        }
        if (basePackages.length == 0) {
            basePackages = new String[]{ClassUtils.getPackageName((String)metadata.getClassName())};
        }
        this.registrar.register(basePackages);
    }

    private Class<?>[] getClients(Map<String, Object> attrs) {
        Object[] clients = (Class[])attrs.getOrDefault("clients", new Class[0]);
        return !ObjectUtils.isEmpty((Object[])clients) ? clients : this.properties.getClients().toArray(new Class[0]);
    }

    private String[] getBasePackages(Map<String, Object> attrs) {
        Object[] basePackages = (String[])attrs.getOrDefault("value", new String[0]);
        return !ObjectUtils.isEmpty((Object[])basePackages) ? basePackages : this.properties.getBasePackages().toArray(new String[0]);
    }
}

