/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.HttpClientBeanRegistrar;
import io.github.danielliu1123.httpexchange.HttpExchangeProperties;
import io.github.danielliu1123.httpexchange.Util;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

class HttpClientBeanDefinitionRegistry
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private Environment environment;
    private HttpExchangeProperties properties;
    private HttpClientBeanRegistrar registrar;

    HttpClientBeanDefinitionRegistry() {
    }

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry registry) throws BeansException {
        Set<Class<?>> clients;
        if (HttpClientBeanRegistrar.hasRegistered(registry)) {
            return;
        }
        this.properties = this.properties == null ? Util.getProperties(this.environment) : this.properties;
        this.registrar = this.registrar == null ? new HttpClientBeanRegistrar(registry, this.environment) : this.registrar;
        Object[] basePackages = (String[])this.properties.getBasePackages().toArray(String[]::new);
        if (!ObjectUtils.isEmpty((Object[])basePackages)) {
            this.registrar.register((String[])basePackages);
        }
        if (!ObjectUtils.isEmpty(clients = this.properties.getClients())) {
            this.registrar.register((Class[])clients.toArray(Class[]::new));
        }
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }
}

