/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.HttpExchangeUtil;
import io.github.danielliu1123.httpexchange.Util;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.service.annotation.HttpExchange;

class HttpClientBeanRegistrar {
    private static final Set<BeanDefinitionRegistry> registries = ConcurrentHashMap.newKeySet();
    private final ClassPathScanningCandidateComponentProvider scanner = HttpClientBeanRegistrar.getScanner();
    private final BeanDefinitionRegistry registry;
    private final Environment environment;

    public HttpClientBeanRegistrar(BeanDefinitionRegistry registry, Environment environment) {
        this.registry = registry;
        this.environment = environment;
        registries.add(registry);
    }

    public static boolean hasRegistered(BeanDefinitionRegistry registry) {
        return registries.contains(registry);
    }

    public void register(String ... basePackages) {
        Set<String> packages = Set.copyOf(Arrays.asList(basePackages));
        this.registerBeans4BasePackages(packages);
    }

    public void register(Class<?> ... clients) {
        for (Class<?> client : clients) {
            this.registerHttpClientBean(this.registry, client.getName());
        }
    }

    private void registerHttpClientBean(BeanDefinitionRegistry registry, String className) {
        Class<?> clz = Class.forName(className);
        if (!clz.isInterface()) {
            throw new IllegalArgumentException(className + " is not an interface");
        }
        if (!Util.isHttpExchangeInterface(clz)) {
            return;
        }
        Assert.isInstanceOf(ConfigurableBeanFactory.class, (Object)registry);
        HttpExchangeUtil.registerHttpExchangeBean((DefaultListableBeanFactory)registry, this.environment, clz);
    }

    private static ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(@Nonnull AnnotatedBeanDefinition abd) {
                return true;
            }
        };
        provider.addIncludeFilter((mr, mrf) -> HttpClientBeanRegistrar.isHttpExchange(mr));
        return provider;
    }

    private static boolean isHttpExchange(MetadataReader mr) {
        ClassMetadata cm = mr.getClassMetadata();
        AnnotationMetadata am = mr.getAnnotationMetadata();
        return cm.isInterface() && cm.isIndependent() && !cm.isAnnotation() && (am.hasAnnotatedMethods(HttpExchange.class.getName()) || am.hasAnnotatedMethods(RequestMapping.class.getName()));
    }

    private void registerBeans4BasePackages(Collection<String> basePackages) {
        for (String pkg : basePackages) {
            Set beanDefinitions = this.scanner.findCandidateComponents(pkg);
            for (BeanDefinition bd : beanDefinitions) {
                if (bd.getBeanClassName() == null) continue;
                this.registerHttpClientBean(this.registry, bd.getBeanClassName());
            }
        }
    }

    static void clear() {
        registries.clear();
    }
}

