/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.BeanParamArgumentResolver;
import io.github.danielliu1123.httpexchange.Cache;
import io.github.danielliu1123.httpexchange.Checker;
import io.github.danielliu1123.httpexchange.HttpClientBeanDefinitionRegistry;
import io.github.danielliu1123.httpexchange.HttpClientBeanRegistrar;
import io.github.danielliu1123.httpexchange.HttpExchangeBeanFactoryInitializationAotProcessor;
import io.github.danielliu1123.httpexchange.HttpExchangeClientHttpRequestInterceptor;
import io.github.danielliu1123.httpexchange.HttpExchangeProperties;
import io.github.danielliu1123.httpexchange.RequestConfiguratorBeanPostProcessor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.client.ClientHttpRequestInterceptor;

@AutoConfiguration
@ConditionalOnProperty(prefix="http-exchange", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={HttpExchangeProperties.class})
public class HttpExchangeAutoConfiguration
implements DisposableBean {
    @Bean
    static HttpClientBeanDefinitionRegistry httpClientBeanDefinitionRegistry() {
        return new HttpClientBeanDefinitionRegistry();
    }

    @Bean
    static RequestConfiguratorBeanPostProcessor requestConfiguratorBeanPostProcessor() {
        return new RequestConfiguratorBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public BeanParamArgumentResolver beanParamArgumentResolver(HttpExchangeProperties properties) {
        return new BeanParamArgumentResolver(properties);
    }

    @Bean
    @ConditionalOnProperty(prefix="http-exchange", name={"warn-unused-config-enabled"}, matchIfMissing=true)
    public CommandLineRunner unusedConfigChecker(HttpExchangeProperties properties) {
        return args -> Checker.checkUnusedConfig(properties);
    }

    @Bean
    public RestClientCustomizer httpExchangeClientHttpRequestInterceptorRestClientCustomizer() {
        return builder -> builder.requestInterceptor((ClientHttpRequestInterceptor)new HttpExchangeClientHttpRequestInterceptor());
    }

    @Bean
    @Lazy
    public RestTemplateCustomizer httpExchangeClientHttpRequestInterceptorRestTemplateCustomizer() {
        return restTemplate -> restTemplate.getInterceptors().add(new HttpExchangeClientHttpRequestInterceptor());
    }

    public void destroy() {
        Cache.clear();
        HttpClientBeanRegistrar.clear();
    }

    @Bean
    static HttpExchangeBeanFactoryInitializationAotProcessor httpExchangeStarterHttpExchangeBeanFactoryInitializationAotProcessor() {
        return new HttpExchangeBeanFactoryInitializationAotProcessor();
    }
}

