/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.HttpExchangeUtil;
import io.github.danielliu1123.httpexchange.Util;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.env.Environment;
import org.springframework.javapoet.MethodSpec;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class HttpExchangeBeanFactoryInitializationAotProcessor
implements BeanRegistrationExcludeFilter,
BeanFactoryInitializationAotProcessor {
    HttpExchangeBeanFactoryInitializationAotProcessor() {
    }

    public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
        return Util.isHttpExchangeInterface(registeredBean.getBeanClass());
    }

    @Nullable
    public BeanFactoryInitializationAotContribution processAheadOfTime(@Nonnull ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            Map<String, BeanDefinition> definitions = HttpExchangeBeanFactoryInitializationAotProcessor.listDefinition(beanFactory);
            if (definitions.isEmpty()) {
                return;
            }
            HttpExchangeBeanFactoryInitializationAotProcessor.registerProxies(generationContext, definitions);
            MethodReference methodReference = beanFactoryInitializationCode.getMethods().add("registerHttpExchangeClientBeanDefinitions", method -> HttpExchangeBeanFactoryInitializationAotProcessor.buildMethod(method, definitions)).toMethodReference();
            beanFactoryInitializationCode.addInitializer(methodReference);
        };
    }

    private static void registerProxies(GenerationContext generationContext, Map<String, BeanDefinition> definitions) {
        ProxyHints proxies = generationContext.getRuntimeHints().proxies();
        definitions.values().stream().map(beanDefinition -> beanDefinition.getResolvableType().resolve()).filter(Objects::nonNull).map(e -> (Class[])ObjectUtils.addObjectToArray((Object[])ClassUtils.getAllInterfacesForClass((Class)e), (Object)e)).flatMap(Arrays::stream).distinct().filter(Util::isHttpExchangeInterface).map(xva$0 -> AopProxyUtils.completeJdkProxyInterfaces((Class[])new Class[]{xva$0})).forEach(arg_0 -> ((ProxyHints)proxies).registerJdkProxy(arg_0));
    }

    private static void buildMethod(MethodSpec.Builder method, Map<String, BeanDefinition> definitions) {
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(DefaultListableBeanFactory.class, "beanFactory", new Modifier[0]);
        method.addParameter(Environment.class, "environment", new Modifier[0]);
        definitions.forEach((beanName, beanDefinition) -> {
            Class clientClass = beanDefinition.getResolvableType().resolve();
            method.addStatement("$T.registerHttpExchangeBean(beanFactory, environment, $T.class)", new Object[]{HttpExchangeUtil.class, clientClass});
        });
    }

    private static Map<String, BeanDefinition> listDefinition(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
            Class clz = beanDefinition.getResolvableType().resolve();
            if (clz == null || !Util.isHttpExchangeInterface(clz)) continue;
            beanDefinitions.put(name, beanDefinition);
        }
        return beanDefinitions;
    }
}

