/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.HttpExchangeMetadata;
import io.github.danielliu1123.httpexchange.RequestConfigurator;
import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.service.annotation.HttpExchange;

public class RequestConfiguratorBeanPostProcessor
implements BeanPostProcessor {
    private static final Method WITH_TIMEOUT_METHOD = RequestConfiguratorBeanPostProcessor.getWithTimeoutMethod();
    private static final Method ADD_HEADER_METHOD = RequestConfiguratorBeanPostProcessor.getAddHeaderMethod();

    @Nullable
    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) throws BeansException {
        if (bean instanceof RequestConfigurator && AopUtils.isJdkDynamicProxy((Object)bean) && bean instanceof Advised && !AnnotatedElementUtils.hasAnnotation(bean.getClass(), Component.class)) {
            return RequestConfiguratorBeanPostProcessor.createProxy(bean, new HttpExchangeMetadata());
        }
        return bean;
    }

    private static Object createProxy(Object client, HttpExchangeMetadata metadata) {
        Class[] interfaces = (Class[])Arrays.stream(((Advised)client).getProxiedInterfaces()).distinct().toArray(Class[]::new);
        ProxyFactory proxyFactory = new ProxyFactory(interfaces);
        proxyFactory.addAdvice((Advice)new RequestConfiguratorMethodInterceptor(client, metadata));
        return proxyFactory.getProxy();
    }

    private static Method getAddHeaderMethod() {
        return RequestConfigurator.class.getMethod("addHeader", String.class, String[].class);
    }

    private static Method getWithTimeoutMethod() {
        return RequestConfigurator.class.getMethod("withTimeout", Integer.TYPE);
    }

    private record RequestConfiguratorMethodInterceptor(Object client, HttpExchangeMetadata metadata) implements MethodInterceptor
    {
        public Object invoke(MethodInvocation invocation) throws Throwable {
            boolean notSet;
            Method method = invocation.getMethod();
            Object[] args = invocation.getArguments();
            if (ADD_HEADER_METHOD.equals(method)) {
                HttpExchangeMetadata copy = this.metadata.copy();
                Object[] values = (String[])args[1];
                if (!ObjectUtils.isEmpty((Object[])values)) {
                    copy.getHeaders().put((String)args[0], List.of(values));
                }
                return RequestConfiguratorBeanPostProcessor.createProxy(this.client, copy);
            }
            if (WITH_TIMEOUT_METHOD.equals(method)) {
                HttpExchangeMetadata copy = this.metadata.copy();
                copy.setReadTimeout((Integer)args[0]);
                return RequestConfiguratorBeanPostProcessor.createProxy(this.client, copy);
            }
            ReflectionUtils.makeAccessible((Method)method);
            if (RequestConfiguratorMethodInterceptor.isNotHttpRequestMethod(method)) {
                return method.invoke(this.client, args);
            }
            boolean bl = notSet = HttpExchangeMetadata.get() == null;
            if (notSet) {
                HttpExchangeMetadata.set(this.metadata);
            }
            try {
                Object values = method.invoke(this.client, args);
                return values;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                if (notSet) {
                    HttpExchangeMetadata.remove();
                }
            }
        }

        private static boolean isNotHttpRequestMethod(Method method) {
            return !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, HttpExchange.class) && !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, RequestMapping.class);
        }
    }
}

