/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange;

import io.github.danielliu1123.httpexchange.HttpExchangeMetadata;
import java.util.Arrays;
import java.util.function.Supplier;
import org.springframework.util.ObjectUtils;

public final class Requester {
    private final HttpExchangeMetadata metadata = new HttpExchangeMetadata();

    private Requester() {
    }

    public Requester withTimeout(int readTimeout) {
        this.metadata.setReadTimeout(readTimeout);
        return this;
    }

    public Requester addHeader(String key, String ... values) {
        if (!ObjectUtils.isEmpty((Object[])values)) {
            this.metadata.getHeaders().put(key, Arrays.asList(values));
        }
        return this;
    }

    public <T> T call(Supplier<T> supplier) {
        HttpExchangeMetadata.set(this.metadata);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            HttpExchangeMetadata.remove();
        }
    }

    public void call(Runnable runnable) {
        HttpExchangeMetadata.set(this.metadata);
        try {
            runnable.run();
        }
        finally {
            HttpExchangeMetadata.remove();
        }
    }

    public static Requester create() {
        return new Requester();
    }
}

