/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange.shaded.requestfactory;

import io.github.danielliu1123.httpexchange.shaded.requestfactory.ShadedAbstractStreamingClientHttpRequest;
import io.github.danielliu1123.httpexchange.shaded.requestfactory.ShadedJdkClientHttpResponse;
import io.github.danielliu1123.httpexchange.shaded.requestfactory.ShadedOutputStreamPublisher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class ShadedJdkClientHttpRequest
extends ShadedAbstractStreamingClientHttpRequest {
    private static final ShadedOutputStreamPublisher.ByteMapper<ByteBuffer> BYTE_MAPPER = new ByteBufferMapper();
    private static final Set<String> DISALLOWED_HEADERS = ShadedJdkClientHttpRequest.disallowedHeaders();
    private final HttpClient httpClient;
    private final HttpMethod method;
    private final URI uri;
    private final Executor executor;
    @Nullable
    private final Duration timeout;

    public ShadedJdkClientHttpRequest(HttpClient httpClient, URI uri, HttpMethod method, Executor executor, @Nullable Duration readTimeout) {
        this.httpClient = httpClient;
        this.uri = uri;
        this.method = method;
        this.executor = executor;
        this.timeout = readTimeout;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body) throws IOException {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(this.buildRequest(headers, body), (name, value) -> !name.equalsIgnoreCase("X-HttpExchange-Request-Timeout"));
            Duration readTimeout = Optional.ofNullable(headers.getFirst("X-HttpExchange-Request-Timeout")).map(Long::valueOf).map(Duration::ofMillis).orElse(this.timeout);
            if (readTimeout != null) {
                builder.timeout(readTimeout);
            }
            HttpRequest request = builder.build();
            HttpResponse<InputStream> response = readTimeout != null ? this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).get(readTimeout.toMillis(), TimeUnit.MILLISECONDS) : this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            return new ShadedJdkClientHttpResponse(response);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Request was interrupted: " + ex.getMessage(), ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof UncheckedIOException) {
                UncheckedIOException uioEx = (UncheckedIOException)cause;
                throw uioEx.getCause();
            }
            if (cause instanceof RuntimeException) {
                RuntimeException rtEx = (RuntimeException)cause;
                throw rtEx;
            }
            if (cause instanceof IOException) {
                IOException ioEx = (IOException)cause;
                throw ioEx;
            }
            throw new IOException(cause.getMessage(), cause);
        }
        catch (TimeoutException ex) {
            throw new IOException("Request timed out: " + ex.getMessage(), ex);
        }
    }

    private HttpRequest buildRequest(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.uri);
        if (this.timeout != null) {
            builder.timeout(this.timeout);
        }
        headers.forEach((headerName, headerValues) -> {
            if (!DISALLOWED_HEADERS.contains(headerName.toLowerCase())) {
                for (String headerValue : headerValues) {
                    builder.header((String)headerName, headerValue);
                }
            }
        });
        builder.method(this.method.name(), this.bodyPublisher(headers, body));
        return builder.build();
    }

    private HttpRequest.BodyPublisher bodyPublisher(HttpHeaders headers, @Nullable StreamingHttpOutputMessage.Body body) {
        if (body != null) {
            Flow.Publisher<ByteBuffer> outputStreamPublisher = ShadedOutputStreamPublisher.create(outputStream -> body.writeTo(StreamUtils.nonClosing((OutputStream)outputStream)), BYTE_MAPPER, this.executor);
            long contentLength = headers.getContentLength();
            if (contentLength > 0L) {
                return HttpRequest.BodyPublishers.fromPublisher(outputStreamPublisher, contentLength);
            }
            if (contentLength == 0L) {
                return HttpRequest.BodyPublishers.noBody();
            }
            return HttpRequest.BodyPublishers.fromPublisher(outputStreamPublisher);
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    private static Set<String> disallowedHeaders() {
        TreeSet<String> headers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headers.addAll(Set.of("connection", "content-length", "expect", "host", "upgrade"));
        String headersToAllow = System.getProperty("jdk.httpclient.allowRestrictedHeaders");
        if (headersToAllow != null) {
            Set toAllow = StringUtils.commaDelimitedListToSet((String)headersToAllow);
            headers.removeAll(toAllow);
        }
        return Collections.unmodifiableSet(headers);
    }

    private static final class ByteBufferMapper
    implements ShadedOutputStreamPublisher.ByteMapper<ByteBuffer> {
        private ByteBufferMapper() {
        }

        @Override
        public ByteBuffer map(int b) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1);
            byteBuffer.put((byte)b);
            byteBuffer.flip();
            return byteBuffer;
        }

        @Override
        public ByteBuffer map(byte[] b, int off, int len) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(len);
            byteBuffer.put(b, off, len);
            byteBuffer.flip();
            return byteBuffer;
        }
    }
}

