/*
 * Decompiled with CFR 0.152.
 */
package io.github.danielliu1123.httpexchange.shaded.requestfactory;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;

class ShadedJdkClientHttpResponse
implements ClientHttpResponse {
    private final HttpResponse<InputStream> response;
    private final HttpHeaders headers;
    private final InputStream body;

    public ShadedJdkClientHttpResponse(HttpResponse<InputStream> response) {
        this.response = response;
        this.headers = ShadedJdkClientHttpResponse.adaptHeaders(response);
        InputStream inputStream = response.body();
        this.body = inputStream != null ? inputStream : InputStream.nullInputStream();
    }

    private static HttpHeaders adaptHeaders(HttpResponse<?> response) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(rawHeaders.size(), Locale.ENGLISH);
        MultiValueMap multiValueMap = CollectionUtils.toMultiValueMap((Map)map);
        multiValueMap.putAll(rawHeaders);
        return HttpHeaders.readOnlyHttpHeaders((MultiValueMap)multiValueMap);
    }

    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf((int)this.response.statusCode());
    }

    public String getStatusText() {
        HttpStatusCode httpStatusCode = this.getStatusCode();
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        return this.body;
    }

    public void close() {
        try {
            try {
                StreamUtils.drain((InputStream)this.body);
            }
            finally {
                this.body.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

