/*
 * Decompiled with CFR 0.152.
 */
package io.github.danushka96;

import io.github.danushka96.enums.License;
import io.github.danushka96.models.Embed;
import io.github.danushka96.models.Live;
import io.github.danushka96.models.Privacy;
import io.github.danushka96.models.ReviewPage;
import io.github.danushka96.models.Spatial;
import io.github.danushka96.models.VimeoVideoMeta;

public final class DefaultVideoMetaBuilder {
    private Spatial spatial;
    private String[] content_rating;
    private String description;
    private Embed embed;
    private Privacy privacy;
    private String license;
    private Live live;
    private String locale;
    private String name;
    private String password;
    private ReviewPage review_page;
    private String scheduled_start_time;

    public DefaultVideoMetaBuilder withContentRating(String[] content_rating) {
        this.content_rating = content_rating;
        return this;
    }

    public DefaultVideoMetaBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public DefaultVideoMetaBuilder withEmbed(Embed embed) {
        this.embed = embed;
        return this;
    }

    public DefaultVideoMetaBuilder withLicence(License license) {
        this.license = license.getVal();
        return this;
    }

    public DefaultVideoMetaBuilder withLive(Live live) {
        this.live = live;
        return this;
    }

    public DefaultVideoMetaBuilder withLocal(String local) {
        this.locale = local;
        return this;
    }

    public DefaultVideoMetaBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public DefaultVideoMetaBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public DefaultVideoMetaBuilder withPrivacy(Privacy privacy) {
        this.privacy = privacy;
        return this;
    }

    public DefaultVideoMetaBuilder withReviewPage(ReviewPage review_page) {
        this.review_page = review_page;
        return this;
    }

    public DefaultVideoMetaBuilder withScheduledStartTime(String scheduledStartTime) {
        this.scheduled_start_time = scheduledStartTime;
        return this;
    }

    public DefaultVideoMetaBuilder withSpatial(Spatial spatial) {
        this.spatial = spatial;
        return this;
    }

    public VimeoVideoMeta build() {
        return new VimeoVideoMeta(this.content_rating, this.description, this.privacy, this.embed, this.license, this.live, this.locale, this.name, this.password, this.review_page, this.scheduled_start_time, this.spatial);
    }
}

