/*
 * Decompiled with CFR 0.152.
 */
package io.github.danushka96;

import io.github.danushka96.VideoService;
import io.github.danushka96.dtos.GetMeResponse;
import io.github.danushka96.dtos.VimeoInitVideoResponse;
import io.github.danushka96.models.VideoMeta;
import io.github.danushka96.models.VimeoGetVideoResponse;
import io.github.danushka96.models.VimeoVideoMeta;
import java.time.Duration;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class VimeoVideoService
implements VideoService {
    private final WebClient webClient;
    private final String token;

    public VimeoVideoService(String token) {
        this.token = token;
        String endPoint = "https://api.vimeo.com";
        this.webClient = WebClient.builder().baseUrl(endPoint).defaultHeader("Authorization", new String[]{"bearer " + token}).build();
    }

    @Override
    public Mono<String> getVideos() {
        return this.webClient.get().uri("/me/videos", new Object[0]).retrieve().bodyToMono(String.class).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).jitter(0.75));
    }

    @Override
    public Mono<String> uploadVideo(String uri, FilePart fileName) {
        return WebClient.builder().baseUrl(uri).defaultHeader("Authorization", new String[]{"bearer " + this.token}).build().post().contentType(MediaType.MULTIPART_FORM_DATA).body((BodyInserter)BodyInserters.fromMultipartData(this.fromFile(fileName))).retrieve().bodyToMono(String.class).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).jitter(0.75));
    }

    @Override
    public Mono<String> deleteVideo(String videoId) {
        return this.webClient.delete().uri("/videos/" + videoId, new Object[0]).retrieve().bodyToMono(String.class).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).jitter(0.75));
    }

    private MultiValueMap<String, HttpEntity<?>> fromFile(FilePart file) {
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("file_data", (Object)file);
        return builder.build();
    }

    public Mono<GetMeResponse> getStats() {
        return this.webClient.get().uri("/me", new Object[0]).retrieve().bodyToMono(GetMeResponse.class).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).jitter(0.75));
    }

    public Mono<VimeoGetVideoResponse> getVideo(String videoId) {
        return this.webClient.get().uri(String.format("/videos/%s", videoId), new Object[0]).retrieve().bodyToMono(VimeoGetVideoResponse.class).doOnError(err -> new VimeoGetVideoResponse()).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).filter(err -> !(err instanceof WebClientResponseException.NotFound)).jitter(0.75));
    }

    public Mono<VimeoInitVideoResponse> initVideoUploadMeta(VideoMeta videoMeta) {
        if (videoMeta instanceof VimeoVideoMeta) {
            VimeoVideoMeta meta = (VimeoVideoMeta)videoMeta;
            try {
                return ((WebClient.RequestBodySpec)this.webClient.post().uri("/me/videos", new Object[0])).body(BodyInserters.fromValue((Object)meta)).retrieve().bodyToMono(VimeoInitVideoResponse.class).retryWhen((Retry)Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).jitter(0.75));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Mono.empty();
    }
}

