/*
 * Decompiled with CFR 0.152.
 */
package textFormatter;

import org.jetbrains.annotations.NotNull;
import textFormatter.TextFormatter;

public enum FormatOption {
    RESET_ALL(0),
    BOLD(1),
    DIM(2),
    ITALIC(3),
    UNDERLINE(4),
    BLINK(5),
    REVERSE(7),
    HIDDEN(8),
    STRIKETHROUGH(9);

    private final byte value;

    private FormatOption(int value) {
        this.value = (byte)value;
    }

    @NotNull
    public String toString() {
        return this.seq();
    }

    @NotNull
    public String seq() {
        return TextFormatter.getSequence(this.value);
    }

    @NotNull
    public String reset() {
        return TextFormatter.getSequence(this == RESET_ALL ? this.value : this.value + 20 + (this == BOLD ? 1 : 0));
    }
}

