/*
 * Decompiled with CFR 0.152.
 */
package textFormatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import textFormatter.FormatOption;
import textFormatter.color.Color;
import textFormatter.color.SimpleColor;

public class TextFormatter {
    public static boolean enableSequences = !TextFormatter.isColorDisabledEnv();
    @NotNull
    public static Color defaultColor = SimpleColor.BRIGHT_WHITE;
    public static boolean startWithDefaultColorIfNotDefined = true;
    public static boolean debug = false;
    @NotNull
    private final ArrayList<FormatOption> formatOptions = new ArrayList(5);
    @NotNull
    private final List<Object> concatList = new ArrayList<Object>(0);
    @Nullable
    private TextFormatter parent;
    @Nullable
    private Color foregroundColor;
    @Nullable
    private Color backgroundColor;
    @Nullable
    private String concatGap;
    @NotNull
    private String contents;

    protected TextFormatter(@NotNull String contents) {
        this.contents = contents;
    }

    public static TextFormatter of(@NotNull String contents) {
        return new TextFormatter(contents);
    }

    public static TextFormatter of(@NotNull String contents, @NotNull Color foreground) {
        return TextFormatter.of(contents).withForegroundColor(foreground);
    }

    public static TextFormatter of(@NotNull String contents, @NotNull Color foreground, @NotNull Color background) {
        return TextFormatter.of(contents).withColors(foreground, background);
    }

    public static TextFormatter create() {
        return new TextFormatter("");
    }

    @NotNull
    public static TextFormatter error(@NotNull String msg) {
        return TextFormatter.of(msg, SimpleColor.BLACK, SimpleColor.BRIGHT_RED).addFormat(FormatOption.BOLD);
    }

    public TextFormatter addFormat(FormatOption ... options) {
        this.formatOptions.addAll(Arrays.asList(options));
        return this;
    }

    public TextFormatter removeFormat(FormatOption ... options) {
        this.formatOptions.removeAll(Arrays.asList(options));
        return this;
    }

    public TextFormatter withForegroundColor(@Nullable Color foreground) {
        this.foregroundColor = foreground;
        return this;
    }

    public TextFormatter withBackgroundColor(@Nullable Color background) {
        this.backgroundColor = background;
        return this;
    }

    public TextFormatter withColors(@Nullable Color foreground, @Nullable Color background) {
        this.foregroundColor = foreground;
        this.backgroundColor = background;
        return this;
    }

    public TextFormatter withContents(@NotNull String contents) {
        this.contents = contents;
        return this;
    }

    public TextFormatter withConcatGap(@Nullable String gap) {
        this.concatGap = gap;
        return this;
    }

    public TextFormatter concat(Object ... objects) {
        for (Object object : objects) {
            if (object instanceof TextFormatter) {
                TextFormatter tf = (TextFormatter)object;
                this.concatFormatter(tf);
                continue;
            }
            this.concatList.add(object);
        }
        return this;
    }

    private void concatFormatter(@NotNull TextFormatter formatter) {
        if (formatter.parent != null) {
            throw new IllegalArgumentException("Cannot concatenate a formatter that is already concatenated to another formatter.");
        }
        formatter.parent = this;
        this.concatList.add(formatter);
    }

    public boolean isSimple() {
        return (this.contents.isEmpty() || this.isFormattingNotDefined()) && this.concatList.isEmpty();
    }

    public boolean isFormattingNotDefined() {
        return this.foregroundColor == null && this.backgroundColor == null && this.formatOptions.isEmpty();
    }

    @NotNull
    private String getStartSequences() {
        if (this.isFormattingNotDefined()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (this.foregroundColor != null) {
            buffer.append(this.foregroundColor);
        } else if (startWithDefaultColorIfNotDefined && this.parent == null) {
            buffer.append(defaultColor);
        }
        if (this.backgroundColor != null) {
            buffer.append(this.backgroundColor.bg());
        }
        for (FormatOption option : this.formatOptions) {
            buffer.append((Object)option);
        }
        return buffer.toString();
    }

    @NotNull
    private String getEndSequences() {
        if (this.isFormattingNotDefined()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        Runnable addResetFg = () -> {
            Color resetFgColor = this.getResetFgColor();
            if (resetFgColor != null) {
                buffer.append(resetFgColor);
            }
        };
        if (this.backgroundColor != null) {
            Color bgColor = this.getResetBgColor();
            if (bgColor == null) {
                buffer.append((Object)FormatOption.RESET_ALL);
                addResetFg.run();
                return buffer.toString();
            }
            buffer.append(bgColor.bg());
        }
        for (FormatOption option : this.formatOptions) {
            buffer.append(option.reset());
        }
        if (this.foregroundColor != null) {
            addResetFg.run();
        }
        return buffer.toString();
    }

    @Nullable
    private Color getResetFgColor() {
        if (this.parent == null) {
            if (this.foregroundColor != defaultColor) {
                return defaultColor;
            }
            return null;
        }
        if (this.parent.foregroundColor != null) {
            return this.parent.foregroundColor;
        }
        return this.parent.getResetFgColor();
    }

    @Nullable
    private Color getResetBgColor() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.backgroundColor != null) {
            return this.parent.backgroundColor;
        }
        return this.parent.getResetBgColor();
    }

    @NotNull
    public String toString() {
        if (!enableSequences && this.concatList.isEmpty() || this.isSimple()) {
            return this.contents;
        }
        StringBuilder buff = new StringBuilder();
        if (enableSequences) {
            buff.append(this.getStartSequences());
        }
        buff.append(this.contents);
        List<Object> concatList = this.concatList;
        for (int i = 0; i < concatList.size(); ++i) {
            buff.append(concatList.get(i));
            if (this.concatGap == null || i >= concatList.size() - 1) continue;
            buff.append(this.concatGap);
            if (!this.concatGap.contains("\n")) continue;
            buff.append(this.getStartSequences());
        }
        if (enableSequences) {
            buff.append(this.getEndSequences());
        }
        return buff.toString();
    }

    @NotNull
    public static String getSequence(Object ... values) {
        if (!enableSequences) {
            return "";
        }
        String joined = String.join((CharSequence)";", (CharSequence[])Arrays.stream(values).map(Object::toString).toArray(String[]::new));
        if (debug) {
            return "ESC[" + joined + "]";
        }
        return "\u001b[" + joined + "m";
    }

    public static boolean isColorDisabledEnv() {
        return System.getenv("NO_COLOR") != null;
    }
}

