/*
 * Decompiled with CFR 0.152.
 */
package textFormatter.color;

import org.jetbrains.annotations.NotNull;
import textFormatter.TextFormatter;
import textFormatter.color.Color;

public enum SimpleColor implements Color
{
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    MAGENTA(35),
    CYAN(36),
    WHITE(37),
    GRAY(90),
    BRIGHT_RED(91),
    BRIGHT_GREEN(92),
    BRIGHT_YELLOW(93),
    BRIGHT_BLUE(94),
    BRIGHT_MAGENTA(95),
    BRIGHT_CYAN(96),
    BRIGHT_WHITE(97);

    private final byte value;
    @NotNull
    public static final SimpleColor[] BRIGHT_COLORS;
    @NotNull
    public static final SimpleColor[] DARK_COLORS;

    private SimpleColor(int value) {
        this.value = (byte)value;
    }

    @Override
    @NotNull
    public String fg() {
        return TextFormatter.getSequence(this.value);
    }

    @Override
    @NotNull
    public String bg() {
        return TextFormatter.getSequence(this.value + 10);
    }

    @Override
    @NotNull
    public String toString() {
        return this.fg();
    }

    static {
        BRIGHT_COLORS = new SimpleColor[]{BRIGHT_RED, BRIGHT_GREEN, BRIGHT_YELLOW, BRIGHT_BLUE, BRIGHT_MAGENTA, BRIGHT_CYAN, BRIGHT_WHITE};
        DARK_COLORS = new SimpleColor[]{RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE};
    }
}

