/*
 * Decompiled with CFR 0.152.
 */
package textFormatter.color;

import org.jetbrains.annotations.NotNull;
import textFormatter.TextFormatter;
import textFormatter.color.Color;

public class TrueColor
implements Color {
    public static final TrueColor BLACK = TrueColor.of(0, 0, 0);
    public static final TrueColor RED = TrueColor.of(255, 0, 0);
    public static final TrueColor GREEN = TrueColor.of(0, 255, 0);
    public static final TrueColor YELLOW = TrueColor.of(255, 255, 0);
    public static final TrueColor BLUE = TrueColor.of(0, 0, 255);
    public static final TrueColor MAGENTA = TrueColor.of(255, 0, 255);
    public static final TrueColor CYAN = TrueColor.of(0, 255, 255);
    public static final TrueColor WHITE = TrueColor.of(255, 255, 255);
    private final byte r;
    private final byte g;
    private final byte b;

    private TrueColor(byte r, byte g, byte b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @NotNull
    public static TrueColor of(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("Color components must be in the range 0-255");
        }
        return new TrueColor((byte)r, (byte)g, (byte)b);
    }

    @NotNull
    public static TrueColor of(int rgb) {
        return TrueColor.of(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public byte r() {
        return this.r;
    }

    public byte g() {
        return this.g;
    }

    public byte b() {
        return this.b;
    }

    @Override
    @NotNull
    public String fg() {
        return this.getSequence(true);
    }

    @Override
    @NotNull
    public String bg() {
        return this.getSequence(false);
    }

    @NotNull
    private String getSequence(boolean fg) {
        return TextFormatter.getSequence(fg ? 38 : 48, 2, this.r & 0xFF, this.g & 0xFF, this.b & 0xFF);
    }

    @Override
    @NotNull
    public String toString() {
        return this.fg();
    }
}

