/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.datesAndText;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class AroundTheWorld {
    private static PrintWriter out = new PrintWriter(System.out, true);
    private static PrintWriter err = new PrintWriter(System.err, true);

    private static void usage() {
        err.println("usage: java AroundTheWorld [options]");
        err.println("  -country code      Which country?");
        err.println("  -language code     Which language?");
        err.println("  -timeZone code     Which time zone?");
        err.println("If any code is ??, then all possible values for that code are printed");
        System.exit(1);
    }

    private static void printAvailableLocales(Locale locale) {
        Locale[] locales = Locale.getAvailableLocales();
        out.println("Available locales:");
        for (int i = 0; i < locales.length; ++i) {
            Locale l = locales[i];
            out.println("Locale " + i + " of " + locales.length);
            out.println("  Name: " + l.getDisplayName(locale));
            out.println("  Country: " + l.getDisplayCountry(locale) + " (" + l.getCountry() + ")");
            out.println("  Language: " + l.getDisplayLanguage(locale) + " (" + l.getLanguage() + ")");
            out.println("  Variant: " + l.getDisplayVariant(locale) + " (" + l.getVariant() + ")");
        }
    }

    private static void printTimeZones(Locale locale) {
        String[] codes = TimeZone.getAvailableIDs();
        out.println("Time zones");
        for (int i = 0; i < codes.length; ++i) {
            String code = codes[i];
            TimeZone tz = TimeZone.getTimeZone(code);
            out.println("  " + code + ": " + tz.getDisplayName(locale));
        }
    }

    private static void printToday(Locale locale, TimeZone tz) {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, locale);
        df.setTimeZone(tz);
        out.println("Right now: " + df.format(new Date()));
    }

    private static void printNumber(double number, Locale locale) {
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        out.println("A number: " + nf.format(number));
        nf = NumberFormat.getCurrencyInstance(locale);
        out.println("Currency: " + nf.format(number));
        nf = NumberFormat.getPercentInstance(locale);
        out.println("Percent: " + nf.format(number));
    }

    public static void main(String[] args) {
        TimeZone timeZone;
        Locale locale;
        String countryCode = null;
        String languageCode = null;
        String timeZoneCode = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-country")) {
                if (++i >= args.length) {
                    err.println("** Missing country code");
                    AroundTheWorld.usage();
                }
                countryCode = args[i];
                continue;
            }
            if (args[i].equals("-language")) {
                if (++i >= args.length) {
                    err.println("** Missing language code");
                    AroundTheWorld.usage();
                }
                languageCode = args[i];
                continue;
            }
            if (args[i].equals("-timeZone")) {
                if (++i >= args.length) {
                    err.println("** Missing time zone code");
                    AroundTheWorld.usage();
                }
                timeZoneCode = args[i];
                continue;
            }
            err.println("** Unknown option: " + args[i]);
            AroundTheWorld.usage();
        }
        if (countryCode == null) {
            locale = Locale.getDefault();
        } else if (countryCode.equals("??")) {
            locale = Locale.getDefault();
            AroundTheWorld.printAvailableLocales(locale);
        } else if (languageCode == null) {
            locale = Locale.getDefault();
        } else if (languageCode.equals("??")) {
            locale = Locale.getDefault();
            AroundTheWorld.printAvailableLocales(locale);
        } else {
            locale = new Locale(languageCode, countryCode);
        }
        if (timeZoneCode == null) {
            timeZone = TimeZone.getDefault();
        } else if (timeZoneCode.equals("??")) {
            timeZone = TimeZone.getDefault();
            AroundTheWorld.printTimeZones(locale);
        } else {
            timeZone = TimeZone.getTimeZone(timeZoneCode);
        }
        out.println("");
        AroundTheWorld.printToday(locale, timeZone);
        AroundTheWorld.printNumber(1234.56, locale);
        out.println("");
    }
}

