/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.pdx.cs.joy.di.Book;
import edu.pdx.cs.joy.di.BookInventory;
import edu.pdx.cs.joy.di.DataDirectory;
import edu.pdx.cs.joy.di.JaxbDatabase;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class BookDatabase
extends JaxbDatabase
implements BookInventory {
    private final Map<Book, AtomicInteger> inventory;

    @Inject
    public BookDatabase(@DataDirectory File directory) throws JAXBException, IOException {
        this(directory, "books.xml");
    }

    BookDatabase(File directory, String fileName) throws IOException, JAXBException {
        super(directory, fileName, XmlBookDatabase.class, XmlBookDatabase.BookCount.class, Book.class);
        XmlBookDatabase xml = (XmlBookDatabase)this.readFile();
        this.inventory = xml != null ? xml.getMap() : new HashMap<Book, AtomicInteger>();
    }

    @Override
    public synchronized void remove(Book book) {
        AtomicInteger count = this.inventory.get(book);
        if (count == null || count.get() == 0) {
            throw new IllegalStateException("We're out of " + book);
        }
        count.decrementAndGet();
        this.writeInventory();
    }

    @Override
    public synchronized void add(Book ... books) {
        for (Book book : books) {
            AtomicInteger count = this.inventory.get(book);
            if (count == null) {
                count = new AtomicInteger(0);
                this.inventory.put(book, count);
            }
            count.incrementAndGet();
        }
        this.writeInventory();
    }

    private synchronized void writeInventory() {
        this.writeXml(new XmlBookDatabase(this.inventory));
    }

    @Override
    public int getCopies(Book book) {
        AtomicInteger count = this.inventory.get(book);
        if (count == null) {
            return 0;
        }
        return count.get();
    }

    @Override
    public Set<Book> getBooks() {
        return this.inventory.keySet();
    }

    @XmlRootElement(name="book-database")
    private static class XmlBookDatabase {
        @XmlElementWrapper(name="books")
        private List<BookCount> counts;

        public XmlBookDatabase() {
        }

        public XmlBookDatabase(Map<Book, AtomicInteger> inventory) {
            this.counts = new ArrayList<BookCount>(inventory.size());
            for (Map.Entry<Book, AtomicInteger> count : inventory.entrySet()) {
                this.counts.add(new BookCount(count.getKey(), count.getValue()));
            }
        }

        public Map<Book, AtomicInteger> getMap() {
            HashMap<Book, AtomicInteger> map = new HashMap<Book, AtomicInteger>(this.counts.size());
            for (BookCount count : this.counts) {
                Book book = count.getBook();
                AtomicInteger ai = (AtomicInteger)map.get(book);
                if (ai == null) {
                    ai = new AtomicInteger(0);
                    map.put(book, ai);
                }
                ai.addAndGet(count.getCount());
            }
            return map;
        }

        @XmlRootElement(name="count")
        private static class BookCount {
            @XmlElement
            private Book book;
            @XmlAttribute
            private int count;

            public BookCount() {
            }

            public BookCount(Book book, AtomicInteger count) {
                this.book = book;
                this.count = count.get();
            }

            public Book getBook() {
                return this.book;
            }

            public int getCount() {
                return this.count;
            }
        }
    }
}

