/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import edu.pdx.cs.joy.di.Book;
import edu.pdx.cs.joy.di.BookInventory;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class BookInventoryTableModel
extends AbstractTableModel {
    private static final int AUTHOR_COLUMN = 0;
    private static final int TITLE_COLUMN = 1;
    private static final int PRICE_COLUMN = 2;
    private static final int QUANTITY_COLUMN = 3;
    protected final BookInventory inventory;

    public BookInventoryTableModel(BookInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public int getRowCount() {
        return this.inventory.getBooks().size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Author";
            }
            case 1: {
                return "Title";
            }
            case 2: {
                return "Price";
            }
            case 3: {
                return "Quantity";
            }
        }
        throw new IllegalArgumentException("Unknown column: " + column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        Book book = this.getBook(row);
        switch (column) {
            case 0: {
                return book.getAuthor();
            }
            case 1: {
                return book.getTitle();
            }
            case 2: {
                return NumberFormat.getCurrencyInstance().format(book.getPrice());
            }
            case 3: {
                return this.inventory.getCopies(book);
            }
        }
        throw new IllegalArgumentException("Unknown column: " + column);
    }

    public Book getBook(int i) {
        Set<Book> books = this.inventory.getBooks();
        assert (i < books.size());
        Iterator<Book> iter = books.iterator();
        for (int j = 0; j < i; ++j) {
            iter.next();
        }
        return iter.next();
    }

    public Book decrementInventry(int row) {
        Book book = this.getBook(row);
        this.inventory.remove(book);
        this.fireTableCellUpdated(row, 3);
        return book;
    }
}

