/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import edu.pdx.cs.joy.di.Book;
import edu.pdx.cs.joy.di.BookInventory;
import edu.pdx.cs.joy.di.CreditCard;
import edu.pdx.cs.joy.di.CreditCardService;
import edu.pdx.cs.joy.di.CreditCardTransactionException;
import edu.pdx.cs.joy.di.CreditTransactionCode;
import java.util.List;

public class BookStore {
    private final BookInventory inventory;
    private final CreditCardService cardService;

    public BookStore(BookInventory inventory, CreditCardService cardService) {
        this.inventory = inventory;
        this.cardService = cardService;
    }

    public double purchase(List<Book> books, CreditCard card) {
        double total = 0.0;
        for (Book book : books) {
            this.inventory.remove(book);
            total += book.getPrice();
        }
        CreditTransactionCode code = this.cardService.debit(card, total);
        if (code == CreditTransactionCode.SUCCESS) {
            return total;
        }
        throw new CreditCardTransactionException(code);
    }
}

