/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import edu.pdx.cs.joy.di.Book;
import edu.pdx.cs.joy.di.BookDatabase;
import edu.pdx.cs.joy.di.BookInventory;
import edu.pdx.cs.joy.di.BookStoreGUI;
import edu.pdx.cs.joy.di.CheckoutPanel;
import edu.pdx.cs.joy.di.FirstBankOfPSU;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BookStoreApp {
    public static void main(String ... args) throws JAXBException, IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File directory = new File(tmpdir);
        BookDatabase inventory = new BookDatabase(directory);
        BookStoreApp.addBooks(inventory);
        FirstBankOfPSU cardService = new FirstBankOfPSU("localhost", 8080);
        Logger logger = Logger.getLogger("edu.pdx.cs.joy.Logger");
        logger.setLevel(Level.INFO);
        CheckoutPanel panel = new CheckoutPanel(inventory, cardService, logger);
        BookStoreGUI gui = new BookStoreGUI(panel);
        gui.pack();
        gui.setVisible(true);
    }

    protected static void addBooks(BookInventory inventory) {
        BookStoreApp.addBook(inventory, new Book("The Pragmatic Programmer", "Andrew Hunt", 29.95), 4);
        BookStoreApp.addBook(inventory, new Book("Winning", "Jack Welch", 15.95), 3);
        BookStoreApp.addBook(inventory, new Book("Agile Estimating and Planning", "Mike Cohn", 35.99), 2);
    }

    private static void addBook(BookInventory inventory, Book book, int copies) {
        inventory.add(Collections.nCopies(copies, book).toArray(new Book[copies]));
    }
}

