/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import edu.pdx.cs.joy.di.Book;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CartTableModel
extends AbstractTableModel {
    private static final int TITLE_COLUMN = 0;
    private static final int PRICE_COLUMN = 1;
    private List<Book> books = new ArrayList<Book>();
    private NumberFormat PRICE_FORMAT = NumberFormat.getCurrencyInstance();

    @Override
    public int getRowCount() {
        return this.books.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.isLastRow(row)) {
            switch (column) {
                case 0: {
                    return "Total";
                }
                case 1: {
                    double total = 0.0;
                    for (Book book : this.books) {
                        total += book.getPrice();
                    }
                    return this.PRICE_FORMAT.format(total);
                }
            }
            throw new IllegalArgumentException("Unknown column " + column);
        }
        Book book = this.books.get(row);
        switch (column) {
            case 0: {
                return book.getTitle();
            }
            case 1: {
                return NumberFormat.getCurrencyInstance().format(book.getPrice());
            }
        }
        throw new IllegalArgumentException("Unknown column " + column);
    }

    private boolean isLastRow(int row) {
        return row == this.getRowCount() - 1;
    }

    public void addBook(Book book) {
        int row = this.books.size();
        this.books.add(book);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return "Title";
            }
            case 1: {
                return "Price";
            }
        }
        throw new IllegalArgumentException("Unknown column: " + index);
    }

    public double getTotal() {
        String total = (String)this.getValueAt(this.getRowCount() - 1, 1);
        try {
            return this.PRICE_FORMAT.parse(total).doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalStateException("Unparsable total: " + total);
        }
    }
}

