/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import com.google.inject.Inject;
import edu.pdx.cs.joy.di.Book;
import edu.pdx.cs.joy.di.BookInventory;
import edu.pdx.cs.joy.di.CartTable;
import edu.pdx.cs.joy.di.CartTableModel;
import edu.pdx.cs.joy.di.CheckoutInventoryTable;
import edu.pdx.cs.joy.di.CheckoutInventoryTableModel;
import edu.pdx.cs.joy.di.CreditCard;
import edu.pdx.cs.joy.di.CreditCardService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class CheckoutPanel
extends JPanel {
    private final CartTableModel cartTableModel;
    private final Logger logger;

    @Inject
    public CheckoutPanel(BookInventory inventory, CreditCardService cardService, Logger logger) {
        this.setLayout(new BoxLayout(this, 1));
        this.logger = logger;
        this.cartTableModel = new CartTableModel();
        final CheckoutInventoryTableModel inventoryModel = new CheckoutInventoryTableModel(inventory);
        inventoryModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                if (inventoryModel.isLastColumn(event.getColumn())) {
                    for (int i = event.getFirstRow(); i <= event.getLastRow(); ++i) {
                        CheckoutPanel.this.addToCart(inventoryModel.decrementInventry(event.getFirstRow()));
                    }
                }
            }
        });
        this.add(new JScrollPane(new CheckoutInventoryTable(inventoryModel)));
        this.add(Box.createVerticalStrut(20));
        this.add(new JScrollPane(new CartTable(this.cartTableModel)));
        this.add(Box.createVerticalStrut(20));
        this.add(new PaymentPanel(cardService));
        this.add(Box.createVerticalGlue());
        this.setPreferredSize(new Dimension(600, 400));
    }

    private void addToCart(Book book) {
        this.logger.fine("Adding " + book + " to cart");
        this.cartTableModel.addBook(book);
    }

    private class PaymentPanel
    extends JPanel {
        public PaymentPanel(final CreditCardService cardService) {
            this.setLayout(new BoxLayout(this, 0));
            this.add(new JLabel("Credit Card"));
            this.add(Box.createHorizontalStrut(5));
            final JTextField creditCard = new JTextField(30);
            this.add(creditCard);
            this.add(Box.createHorizontalStrut(5));
            JButton purchase = new JButton("Purchase");
            purchase.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String title;
                    String cardNumber;
                    double total = CheckoutPanel.this.cartTableModel.getTotal();
                    String confirmation = "Do you want to charge " + total + " to your " + (cardNumber = creditCard.getText()) + " card?";
                    int confirm = JOptionPane.showConfirmDialog(PaymentPanel.this, confirmation, title = "Confirm charge", 0, 3);
                    if (confirm == 0) {
                        CreditCard card = new CreditCard(cardNumber);
                        cardService.debit(card, total);
                    }
                }
            });
            this.add(Box.createHorizontalStrut(5));
            this.add(purchase);
        }
    }
}

