/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.di;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;

public abstract class JaxbDatabase {
    private final File directory;
    private final String fileName;
    private final JAXBContext xmlContext;
    private final File file;

    protected JaxbDatabase(File directory, String fileName, Class<?> ... jaxbClasses) throws IOException, JAXBException {
        this.directory = directory;
        this.fileName = fileName;
        this.xmlContext = JAXBContext.newInstance((Class[])jaxbClasses);
        this.directory.mkdirs();
        if (!this.directory.exists()) {
            throw new IOException("Could not create data directory: " + this.directory);
        }
        this.file = new File(this.directory, this.fileName);
    }

    protected void writeXml(Object xml) {
        try {
            Marshaller marshaller = this.xmlContext.createMarshaller();
            marshaller.marshal(xml, new File(this.directory, this.fileName));
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Could not save inventory", ex);
        }
    }

    public File getDatabaseFile() {
        return this.file;
    }

    protected Object readFile() throws JAXBException {
        System.out.println("Reading xml data from " + this.file);
        if (this.file.exists()) {
            Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
            return unmarshaller.unmarshal(this.file);
        }
        return null;
    }
}

