/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.examples;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;

public class MailFile {
    private static final PrintWriter err = new PrintWriter(System.err, true);

    private static void usage() {
        err.println("usage: MailFile [options] file recipient [subject]");
        err.println("  Where [options] are:");
        err.println("  -server name   Name of the SMTP server");
        err.println("  -verbose       Print out extra info");
        System.exit(1);
    }

    public static void main(String[] args) {
        StringBuilder subject = null;
        String fileName = null;
        String recipient = null;
        String serverName = "mailhost.pdx.edu";
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-server")) {
                if (++i >= args.length) {
                    err.println("** Missing server name");
                    MailFile.usage();
                }
                serverName = args[i];
            }
            if (args[i].equals("-verbose")) {
                debug = true;
                continue;
            }
            if (fileName == null) {
                fileName = args[i];
                continue;
            }
            if (recipient == null) {
                recipient = args[i];
                continue;
            }
            if (subject == null) {
                subject = new StringBuilder();
            }
            subject.append(args[i]).append(" ");
        }
        if (fileName == null) {
            err.println("** No file specified");
            MailFile.usage();
        }
        if (recipient == null) {
            err.println("** No recipient specified");
            MailFile.usage();
        }
        if (subject == null) {
            subject = new StringBuilder("A file for you");
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", serverName);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(debug);
        MimeMessage message = new MimeMessage(session);
        try {
            InternetAddress[] to = new InternetAddress[]{new InternetAddress(recipient)};
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        catch (AddressException ex) {
            err.println("** Invalid address: " + recipient);
            System.exit(1);
        }
        catch (MessagingException ex) {
            err.println("** MessagingException: " + ex);
            System.exit(1);
        }
        File file = new File(fileName);
        if (!file.exists()) {
            err.println("** File " + file + " does not exist!");
            System.exit(1);
        }
        MimeBodyPart textPart = new MimeBodyPart();
        try {
            textPart.setContent((Object)("File " + file), "text/plain");
        }
        catch (MessagingException ex) {
            err.println("** Exception with text part: " + ex);
            System.exit(1);
        }
        FileDataSource ds = new FileDataSource(file);
        DataHandler dh = new DataHandler((DataSource)ds);
        MimeBodyPart filePart = new MimeBodyPart();
        try {
            filePart.setDataHandler(dh);
            filePart.setFileName(file.getName());
            filePart.setDescription("The file you requested");
        }
        catch (MessagingException ex) {
            err.println("** Exception with file part: " + ex);
            System.exit(1);
        }
        try {
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)textPart);
            mp.addBodyPart((BodyPart)filePart);
            message.setContent((Multipart)mp);
            Transport.send((Message)message);
        }
        catch (MessagingException ex) {
            err.println("** Exception while adding parts and sending: " + ex);
            System.exit(1);
        }
    }
}

