/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipOutputStream;

public class MakeJar {
    private static PrintWriter err = new PrintWriter(System.err, true);

    private static void usage() {
        err.println("usage: MakeJar [options] jarFile [file]+");
        err.println("  Where [options] are:");
        err.println("  -nocompress    Don't compress Jar file");
        err.println("  -author name   Author of Jar file (default: Joy)");
        err.println("  -version n     Version of Jar file (default: 1.0)");
        System.exit(1);
    }

    public static void main(String[] args) {
        String jarFileName = null;
        HashSet<String> fileNames = new HashSet<String>();
        boolean compress = true;
        String author = "Joy";
        String version = "1.0";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-nocompress")) {
                compress = false;
                continue;
            }
            if (args[i].equals("-author")) {
                if (++i >= args.length) {
                    err.println("** Missing author name");
                    MakeJar.usage();
                }
                author = args[i];
                continue;
            }
            if (args[i].equals("-version")) {
                if (++i >= args.length) {
                    err.println("** Missing version");
                    MakeJar.usage();
                }
                version = args[i];
                continue;
            }
            if (jarFileName == null) {
                jarFileName = args[i];
                continue;
            }
            fileNames.add(args[i]);
        }
        if (jarFileName == null) {
            err.println("** No Jar file specified");
            MakeJar.usage();
        }
        if (fileNames.isEmpty()) {
            err.println("** No files specified");
            MakeJar.usage();
        }
        Manifest manifest = new Manifest();
        Attributes global = manifest.getMainAttributes();
        global.put(Attributes.Name.MANIFEST_VERSION, version);
        global.put(new Attributes.Name("Created-By"), author);
        ZipOutputStream jos = null;
        try {
            File jarFile = new File(jarFileName);
            FileOutputStream os = new FileOutputStream(jarFile);
            jos = new JarOutputStream((OutputStream)os, manifest);
        }
        catch (IOException ex) {
            err.println("** IOException: " + ex.getMessage());
            System.exit(1);
        }
        if (compress) {
            jos.setMethod(8);
        } else {
            jos.setMethod(0);
        }
        for (String fileName : fileNames) {
            try {
                File file = new File(fileName);
                JarEntry entry = new JarEntry(fileName);
                entry.setTime(new Date().getTime());
                entry.setSize(file.length());
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[1024];
                int read = 0;
                if (compress) {
                    entry.setMethod(8);
                } else {
                    entry.setMethod(0);
                    CRC32 checksum = new CRC32();
                    checksum.reset();
                    long total = 0L;
                    while ((read = ((InputStream)is).read(buffer)) != -1) {
                        checksum.update(buffer, 0, read);
                        total += (long)read;
                    }
                    if (total != file.length()) {
                        throw new JarException("File length problems during " + file.getPath() + " (" + total + " out of " + file.length() + ")");
                    }
                    entry.setCrc(checksum.getValue());
                }
                ((JarOutputStream)jos).putNextEntry(entry);
                is = new BufferedInputStream(new FileInputStream(file));
                while ((read = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
                    jos.write(buffer, 0, read);
                }
                ((InputStream)is).close();
                jos.closeEntry();
            }
            catch (IOException ex) {
                err.println("** IOException: " + ex.getMessage());
                System.exit(1);
            }
        }
    }
}

