/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.examples;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Reflect {
    private static PrintWriter out = new PrintWriter(System.out, true);
    private static PrintWriter err = new PrintWriter(System.err, true);

    private static void usage() {
        err.println("usage: java Reflect className");
        System.exit(1);
    }

    private static String modifiersString(int modifiers) {
        StringBuffer sb = new StringBuffer();
        if (Modifier.isPublic(modifiers)) {
            sb.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            sb.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            sb.append("private ");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("final ");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("native ");
        }
        if (Modifier.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb.append("synchronized ");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        return sb.toString();
    }

    private static String getTypeName(Class type) {
        Object typeName = type.isArray() ? type.getComponentType().getName() + "[]" : type.getName();
        return typeName;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            err.println("** Missing class name");
            Reflect.usage();
        }
        Class<?> c = null;
        try {
            c = Class.forName(args[0]);
        }
        catch (ClassNotFoundException ex) {
            err.println("** Could not find class " + args[0]);
        }
        out.print(Reflect.modifiersString(c.getModifiers()));
        out.println("class " + Reflect.getTypeName(c));
        if (c.getSuperclass() != null) {
            out.print("    extends " + Reflect.getTypeName(c.getSuperclass()));
        }
        out.println("");
        Class<?>[] interfaces = c.getInterfaces();
        if (interfaces.length > 0) {
            out.print("    implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                out.print(interfaces[i].getName());
                if (i >= interfaces.length - 1) continue;
                out.print(", ");
            }
            out.println("");
        }
        out.println("{");
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            out.print("  " + Reflect.modifiersString(field.getModifiers()));
            String typeName = Reflect.getTypeName(field.getType());
            out.println(typeName + " " + field.getName() + ";");
        }
        out.println("");
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> con = constructors[i];
            out.print("  " + Reflect.modifiersString(con.getModifiers()));
            out.print(con.getName() + "(");
            Class<?>[] params = con.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                Class<?> param = params[j];
                out.print(Reflect.getTypeName(param));
                if (j >= params.length - 1) continue;
                out.print(", ");
            }
            out.print(")");
            Class<?>[] exceptions = con.getExceptionTypes();
            if (exceptions.length > 0) {
                out.print("\n    throws ");
                for (int j = 0; j < exceptions.length; ++j) {
                    Class<?> ex = exceptions[j];
                    out.print(Reflect.getTypeName(ex));
                    if (j >= exceptions.length - 1) continue;
                    out.print(", ");
                }
            }
            out.println(";");
        }
        out.println("");
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            out.print("  " + Reflect.modifiersString(method.getModifiers()));
            out.print(Reflect.getTypeName(method.getReturnType()) + " ");
            out.print(method.getName() + "(");
            Class<?>[] params = method.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                Class<?> param = params[j];
                out.print(Reflect.getTypeName(param));
                if (j >= params.length - 1) continue;
                out.print(", ");
            }
            out.print(")");
            Class<?>[] exceptions = method.getExceptionTypes();
            if (exceptions.length > 0) {
                out.print("\n    throws ");
                for (int j = 0; j < exceptions.length; ++j) {
                    Class<?> ex = exceptions[j];
                    out.print(Reflect.getTypeName(ex));
                    if (j >= exceptions.length - 1) continue;
                    out.print(", ");
                }
            }
            out.println(";");
        }
        out.println("}");
    }
}

