/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.java8;

import java.util.stream.IntStream;

public class ComputePrimeNumbers {
    public static void main(String[] args) {
        int maximumValue = Integer.parseInt(args[0]);
        long serialDuration = ComputePrimeNumbers.timeOperation(() -> ComputePrimeNumbers.computePrimeNumbers(IntStream.rangeClosed(0, maximumValue)));
        long parallelDuration = ComputePrimeNumbers.timeOperation(() -> ComputePrimeNumbers.computePrimeNumbers(IntStream.rangeClosed(0, maximumValue).parallel()));
        System.out.println(String.format("Printed primes less than %d (serial)   in %d nanoseconds", maximumValue, serialDuration));
        System.out.println(String.format("Printed primes less than %d (parallel) in %d nanoseconds", maximumValue, parallelDuration));
    }

    private static void computePrimeNumbers(IntStream stream) {
        long count = stream.filter(ComputePrimeNumbers::isPrime).count();
        System.out.println("Computed " + count + " primes");
    }

    private static long timeOperation(Runnable operation) {
        long start = System.nanoTime();
        operation.run();
        return System.nanoTime() - start;
    }

    private static boolean isPrime(int n) {
        if (n <= 3) {
            return n > 1;
        }
        if (n % 2 == 0 || n % 3 == 0) {
            return false;
        }
        int i = 5;
        while (i * i <= n) {
            if (n % i == 0 || n % (i + 2) == 0) {
                return false;
            }
            i += 6;
        }
        return true;
    }
}

