/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.junit;

import edu.pdx.cs.joy.junit.Course;
import edu.pdx.cs.joy.junit.Student;
import java.util.HashSet;
import java.util.Set;

public class Section {
    public static final int WINTER = 0;
    public static final int SPRING = 1;
    public static final int SUMMER = 2;
    public static final int FALL = 3;
    private Course course;
    private int term;
    private int year;
    private Set<Student> students;

    public Section(Course course, int term, int year) {
        if (term != 0 && term != 1 && term != 2 && term != 3) {
            String s = "Invalid term code: " + term;
            throw new IllegalArgumentException(s);
        }
        this.course = course;
        this.term = term;
        this.year = year;
        this.students = new HashSet<Student>();
    }

    public void addStudent(Student student) {
        this.students.add(student);
    }

    public void dropStudent(Student student) {
        if (!this.students.remove(student)) {
            String s = "Student " + student + " is not enrolled in " + this;
            throw new IllegalArgumentException(s);
        }
    }

    public int getClassSize() {
        return this.students.size();
    }

    public Course getCourse() {
        return this.course;
    }

    public Set<Student> getStudents() {
        return this.students;
    }

    public int getTerm() {
        return this.term;
    }

    public int getYear() {
        return this.year;
    }
}

