/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.net;

import edu.pdx.cs.joy.net.ChatListener;
import edu.pdx.cs.joy.net.ChatMessage;
import edu.pdx.cs.joy.net.ChatSpeaker;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

public class ChatCommunicator
implements Runnable {
    private static PrintStream err = System.err;
    private int port;
    private ChatSpeaker speaker;
    private ChatListener listener;

    public ChatCommunicator(int port) {
        this.port = port;
    }

    public void startup() {
        this.speaker = new ChatSpeaker();
        this.listener = new ChatListener();
        new Thread(this).start();
    }

    @Override
    public void run() {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.port);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (socket == null) {
            try {
                ServerSocket server = new ServerSocket(this.port, 10);
                socket = server.accept();
            }
            catch (IOException ex) {
                err.println("** IOException: " + ex);
                System.exit(1);
            }
        }
        this.speaker.setSocket(socket);
        this.listener.setSocket(socket);
        new Thread(this.speaker).start();
        new Thread(this.listener).start();
    }

    public void sendMessage(ChatMessage message) {
        this.speaker.sendMessage(message);
    }

    public List getMessages() {
        return this.listener.getMessages();
    }
}

