/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.net;

import edu.pdx.cs.joy.net.ChatCommunicator;
import edu.pdx.cs.joy.net.ChatMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;

public class ChatSession {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public static void main(String[] args) {
        String owner = args[0];
        int port = 0;
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            err.println("** Bad port number: " + args[1]);
        }
        out.println("Establishing connection");
        ChatCommunicator communicator = new ChatCommunicator(port);
        communicator.startup();
        try {
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader br = new BufferedReader(isr);
            String line = "";
            while (!line.trim().equals("bye")) {
                Iterator messages = communicator.getMessages().iterator();
                while (messages.hasNext()) {
                    out.println(messages.next());
                }
                out.print(owner + "> ");
                out.flush();
                line = br.readLine();
                if (line.trim().equals("")) continue;
                ChatMessage message = new ChatMessage(owner, line);
                communicator.sendMessage(message);
            }
            out.println("Waiting for other side to shut down");
        }
        catch (IOException ex) {
            err.println("** IOException: " + ex);
            System.exit(1);
        }
    }
}

