/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class DateServer {
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;

    public static void main(String[] args) {
        int port = Integer.parseInt(args[0]);
        try {
            ServerSocket server = new ServerSocket(port, 5);
            for (int i = 0; i < 5; ++i) {
                out.println("Server listening on " + server.getInetAddress() + ":" + server.getLocalPort());
                Socket socket = server.accept();
                out.println("Server accepted client " + i);
                Worker worker = new Worker(socket);
                worker.start();
            }
            out.println("Server exiting");
        }
        catch (IOException ex) {
            err.println("** IOException: " + ex);
            System.exit(1);
        }
    }

    static class Worker
    extends Thread {
        private final Socket socket;

        Worker(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                out.println("Server running on " + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort());
                out.println("Server communicating with " + this.socket.getInetAddress() + ":" + this.socket.getPort());
                Thread.sleep(5000L);
                OutputStream os = this.socket.getOutputStream();
                PrintWriter pw = new PrintWriter(os, true);
                Date now = new Date();
                pw.println(now.toString());
                pw.flush();
                pw.close();
            }
            catch (InterruptedException ex) {
                err.println("** InterruptedException: " + ex);
                System.exit(1);
            }
            catch (IOException ex) {
                err.println("** IOException: " + ex);
                System.exit(1);
            }
        }
    }
}

